/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.BenefitRecommendationsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitRecommendationModelInner;
import com.azure.resourcemanager.costmanagement.implementation.BenefitRecommendationModelImpl;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendationModel;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendations;

public final class BenefitRecommendationsImpl
implements BenefitRecommendations {
    private static final ClientLogger LOGGER = new ClientLogger(BenefitRecommendationsImpl.class);
    private final BenefitRecommendationsClient innerClient;
    private final CostManagementManager serviceManager;

    public BenefitRecommendationsImpl(BenefitRecommendationsClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BenefitRecommendationModel> list(String billingScope) {
        PagedIterable<BenefitRecommendationModelInner> inner = this.serviceClient().list(billingScope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitRecommendationModelImpl((BenefitRecommendationModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BenefitRecommendationModel> list(String billingScope, String filter, String orderby, String expand, Context context) {
        PagedIterable<BenefitRecommendationModelInner> inner = this.serviceClient().list(billingScope, filter, orderby, expand, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitRecommendationModelImpl((BenefitRecommendationModelInner)((Object)inner1), this.manager()));
    }

    private BenefitRecommendationsClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }
}

