/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.BenefitUtilizationSummariesClient;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitUtilizationSummaryInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummariesListResult;
import com.azure.resourcemanager.costmanagement.models.GrainParameter;
import reactor.core.publisher.Mono;

public final class BenefitUtilizationSummariesClientImpl
implements BenefitUtilizationSummariesClient {
    private final BenefitUtilizationSummariesService service;
    private final CostManagementClientImpl client;

    BenefitUtilizationSummariesClientImpl(CostManagementClientImpl client) {
        this.service = (BenefitUtilizationSummariesService)RestProxy.create(BenefitUtilizationSummariesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingAccountIdSinglePageAsync(String billingAccountId, GrainParameter grainParameter, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByBillingAccountId(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountId, grainParameter, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingAccountIdSinglePageAsync(String billingAccountId, GrainParameter grainParameter, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByBillingAccountId(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountId, grainParameter, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingAccountIdAsync(String billingAccountId, GrainParameter grainParameter, String filter) {
        return new PagedFlux(() -> this.listByBillingAccountIdSinglePageAsync(billingAccountId, grainParameter, filter), nextLink -> this.listByBillingAccountIdNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingAccountIdAsync(String billingAccountId) {
        GrainParameter grainParameter = null;
        String filter = null;
        return new PagedFlux(() -> this.listByBillingAccountIdSinglePageAsync(billingAccountId, grainParameter, filter), nextLink -> this.listByBillingAccountIdNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingAccountIdAsync(String billingAccountId, GrainParameter grainParameter, String filter, Context context) {
        return new PagedFlux(() -> this.listByBillingAccountIdSinglePageAsync(billingAccountId, grainParameter, filter, context), nextLink -> this.listByBillingAccountIdNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listByBillingAccountId(String billingAccountId) {
        GrainParameter grainParameter = null;
        String filter = null;
        return new PagedIterable(this.listByBillingAccountIdAsync(billingAccountId, grainParameter, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listByBillingAccountId(String billingAccountId, GrainParameter grainParameter, String filter, Context context) {
        return new PagedIterable(this.listByBillingAccountIdAsync(billingAccountId, grainParameter, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingProfileIdSinglePageAsync(String billingAccountId, String billingProfileId, GrainParameter grainParameter, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        if (billingProfileId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingProfileId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByBillingProfileId(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountId, billingProfileId, grainParameter, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingProfileIdSinglePageAsync(String billingAccountId, String billingProfileId, GrainParameter grainParameter, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        if (billingProfileId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingProfileId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByBillingProfileId(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountId, billingProfileId, grainParameter, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingProfileIdAsync(String billingAccountId, String billingProfileId, GrainParameter grainParameter, String filter) {
        return new PagedFlux(() -> this.listByBillingProfileIdSinglePageAsync(billingAccountId, billingProfileId, grainParameter, filter), nextLink -> this.listByBillingProfileIdNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingProfileIdAsync(String billingAccountId, String billingProfileId) {
        GrainParameter grainParameter = null;
        String filter = null;
        return new PagedFlux(() -> this.listByBillingProfileIdSinglePageAsync(billingAccountId, billingProfileId, grainParameter, filter), nextLink -> this.listByBillingProfileIdNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingProfileIdAsync(String billingAccountId, String billingProfileId, GrainParameter grainParameter, String filter, Context context) {
        return new PagedFlux(() -> this.listByBillingProfileIdSinglePageAsync(billingAccountId, billingProfileId, grainParameter, filter, context), nextLink -> this.listByBillingProfileIdNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listByBillingProfileId(String billingAccountId, String billingProfileId) {
        GrainParameter grainParameter = null;
        String filter = null;
        return new PagedIterable(this.listByBillingProfileIdAsync(billingAccountId, billingProfileId, grainParameter, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listByBillingProfileId(String billingAccountId, String billingProfileId, GrainParameter grainParameter, String filter, Context context) {
        return new PagedIterable(this.listByBillingProfileIdAsync(billingAccountId, billingProfileId, grainParameter, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanOrderSinglePageAsync(String savingsPlanOrderId, String filter, GrainParameter grainParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (savingsPlanOrderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter savingsPlanOrderId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySavingsPlanOrder(this.client.getEndpoint(), this.client.getApiVersion(), filter, grainParameter, savingsPlanOrderId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanOrderSinglePageAsync(String savingsPlanOrderId, String filter, GrainParameter grainParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (savingsPlanOrderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter savingsPlanOrderId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySavingsPlanOrder(this.client.getEndpoint(), this.client.getApiVersion(), filter, grainParameter, savingsPlanOrderId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanOrderAsync(String savingsPlanOrderId, String filter, GrainParameter grainParameter) {
        return new PagedFlux(() -> this.listBySavingsPlanOrderSinglePageAsync(savingsPlanOrderId, filter, grainParameter), nextLink -> this.listBySavingsPlanOrderNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanOrderAsync(String savingsPlanOrderId) {
        String filter = null;
        GrainParameter grainParameter = null;
        return new PagedFlux(() -> this.listBySavingsPlanOrderSinglePageAsync(savingsPlanOrderId, filter, grainParameter), nextLink -> this.listBySavingsPlanOrderNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanOrderAsync(String savingsPlanOrderId, String filter, GrainParameter grainParameter, Context context) {
        return new PagedFlux(() -> this.listBySavingsPlanOrderSinglePageAsync(savingsPlanOrderId, filter, grainParameter, context), nextLink -> this.listBySavingsPlanOrderNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanOrder(String savingsPlanOrderId) {
        String filter = null;
        GrainParameter grainParameter = null;
        return new PagedIterable(this.listBySavingsPlanOrderAsync(savingsPlanOrderId, filter, grainParameter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanOrder(String savingsPlanOrderId, String filter, GrainParameter grainParameter, Context context) {
        return new PagedIterable(this.listBySavingsPlanOrderAsync(savingsPlanOrderId, filter, grainParameter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanIdSinglePageAsync(String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (savingsPlanOrderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter savingsPlanOrderId is required and cannot be null."));
        }
        if (savingsPlanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter savingsPlanId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySavingsPlanId(this.client.getEndpoint(), this.client.getApiVersion(), filter, grainParameter, savingsPlanOrderId, savingsPlanId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanIdSinglePageAsync(String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (savingsPlanOrderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter savingsPlanOrderId is required and cannot be null."));
        }
        if (savingsPlanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter savingsPlanId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySavingsPlanId(this.client.getEndpoint(), this.client.getApiVersion(), filter, grainParameter, savingsPlanOrderId, savingsPlanId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanIdAsync(String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter) {
        return new PagedFlux(() -> this.listBySavingsPlanIdSinglePageAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter), nextLink -> this.listBySavingsPlanIdNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanIdAsync(String savingsPlanOrderId, String savingsPlanId) {
        String filter = null;
        GrainParameter grainParameter = null;
        return new PagedFlux(() -> this.listBySavingsPlanIdSinglePageAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter), nextLink -> this.listBySavingsPlanIdNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanIdAsync(String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter, Context context) {
        return new PagedFlux(() -> this.listBySavingsPlanIdSinglePageAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter, context), nextLink -> this.listBySavingsPlanIdNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanId(String savingsPlanOrderId, String savingsPlanId) {
        String filter = null;
        GrainParameter grainParameter = null;
        return new PagedIterable(this.listBySavingsPlanIdAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanId(String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter, Context context) {
        return new PagedIterable(this.listBySavingsPlanIdAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingAccountIdNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByBillingAccountIdNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingAccountIdNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByBillingAccountIdNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingProfileIdNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByBillingProfileIdNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingProfileIdNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByBillingProfileIdNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanOrderNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySavingsPlanOrderNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanOrderNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySavingsPlanOrderNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanIdNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySavingsPlanIdNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanIdNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySavingsPlanIdNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitUtilizationSummariesListResult)res.getValue()).value(), ((BenefitUtilizationSummariesListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface BenefitUtilizationSummariesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/benefitUtilizationSummaries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitUtilizationSummariesListResult>> listByBillingAccountId(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="billingAccountId") String var3, @QueryParam(value="grainParameter") GrainParameter var4, @QueryParam(value="filter") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/providers/Microsoft.CostManagement/benefitUtilizationSummaries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitUtilizationSummariesListResult>> listByBillingProfileId(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="billingAccountId") String var3, @PathParam(value="billingProfileId") String var4, @QueryParam(value="grainParameter") GrainParameter var5, @QueryParam(value="filter") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.BillingBenefits/savingsPlanOrders/{savingsPlanOrderId}/providers/Microsoft.CostManagement/benefitUtilizationSummaries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitUtilizationSummariesListResult>> listBySavingsPlanOrder(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="grainParameter") GrainParameter var4, @PathParam(value="savingsPlanOrderId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.BillingBenefits/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans/{savingsPlanId}/providers/Microsoft.CostManagement/benefitUtilizationSummaries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitUtilizationSummariesListResult>> listBySavingsPlanId(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="grainParameter") GrainParameter var4, @PathParam(value="savingsPlanOrderId") String var5, @PathParam(value="savingsPlanId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitUtilizationSummariesListResult>> listByBillingAccountIdNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitUtilizationSummariesListResult>> listByBillingProfileIdNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitUtilizationSummariesListResult>> listBySavingsPlanOrderNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitUtilizationSummariesListResult>> listBySavingsPlanIdNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

