/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.BenefitUtilizationSummariesClient;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitUtilizationSummaryInner;
import com.azure.resourcemanager.costmanagement.implementation.BenefitUtilizationSummaryImpl;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummaries;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummary;
import com.azure.resourcemanager.costmanagement.models.GrainParameter;

public final class BenefitUtilizationSummariesImpl
implements BenefitUtilizationSummaries {
    private static final ClientLogger LOGGER = new ClientLogger(BenefitUtilizationSummariesImpl.class);
    private final BenefitUtilizationSummariesClient innerClient;
    private final CostManagementManager serviceManager;

    public BenefitUtilizationSummariesImpl(BenefitUtilizationSummariesClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BenefitUtilizationSummary> listByBillingAccountId(String billingAccountId) {
        PagedIterable<BenefitUtilizationSummaryInner> inner = this.serviceClient().listByBillingAccountId(billingAccountId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitUtilizationSummaryImpl((BenefitUtilizationSummaryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BenefitUtilizationSummary> listByBillingAccountId(String billingAccountId, GrainParameter grainParameter, String filter, Context context) {
        PagedIterable<BenefitUtilizationSummaryInner> inner = this.serviceClient().listByBillingAccountId(billingAccountId, grainParameter, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitUtilizationSummaryImpl((BenefitUtilizationSummaryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BenefitUtilizationSummary> listByBillingProfileId(String billingAccountId, String billingProfileId) {
        PagedIterable<BenefitUtilizationSummaryInner> inner = this.serviceClient().listByBillingProfileId(billingAccountId, billingProfileId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitUtilizationSummaryImpl((BenefitUtilizationSummaryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BenefitUtilizationSummary> listByBillingProfileId(String billingAccountId, String billingProfileId, GrainParameter grainParameter, String filter, Context context) {
        PagedIterable<BenefitUtilizationSummaryInner> inner = this.serviceClient().listByBillingProfileId(billingAccountId, billingProfileId, grainParameter, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitUtilizationSummaryImpl((BenefitUtilizationSummaryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BenefitUtilizationSummary> listBySavingsPlanOrder(String savingsPlanOrderId) {
        PagedIterable<BenefitUtilizationSummaryInner> inner = this.serviceClient().listBySavingsPlanOrder(savingsPlanOrderId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitUtilizationSummaryImpl((BenefitUtilizationSummaryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BenefitUtilizationSummary> listBySavingsPlanOrder(String savingsPlanOrderId, String filter, GrainParameter grainParameter, Context context) {
        PagedIterable<BenefitUtilizationSummaryInner> inner = this.serviceClient().listBySavingsPlanOrder(savingsPlanOrderId, filter, grainParameter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitUtilizationSummaryImpl((BenefitUtilizationSummaryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BenefitUtilizationSummary> listBySavingsPlanId(String savingsPlanOrderId, String savingsPlanId) {
        PagedIterable<BenefitUtilizationSummaryInner> inner = this.serviceClient().listBySavingsPlanId(savingsPlanOrderId, savingsPlanId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitUtilizationSummaryImpl((BenefitUtilizationSummaryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BenefitUtilizationSummary> listBySavingsPlanId(String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter, Context context) {
        PagedIterable<BenefitUtilizationSummaryInner> inner = this.serviceClient().listBySavingsPlanId(savingsPlanOrderId, savingsPlanId, filter, grainParameter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BenefitUtilizationSummaryImpl((BenefitUtilizationSummaryInner)((Object)inner1), this.manager()));
    }

    private BenefitUtilizationSummariesClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }
}

