/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.costmanagement.fluent.AlertsClient;
import com.azure.resourcemanager.costmanagement.fluent.BenefitRecommendationsClient;
import com.azure.resourcemanager.costmanagement.fluent.BenefitUtilizationSummariesClient;
import com.azure.resourcemanager.costmanagement.fluent.CostManagementClient;
import com.azure.resourcemanager.costmanagement.fluent.DimensionsClient;
import com.azure.resourcemanager.costmanagement.fluent.ExportsClient;
import com.azure.resourcemanager.costmanagement.fluent.ForecastsClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateCostDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationResultsClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationStatusClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateReservationDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.OperationsClient;
import com.azure.resourcemanager.costmanagement.fluent.PriceSheetsClient;
import com.azure.resourcemanager.costmanagement.fluent.QueriesClient;
import com.azure.resourcemanager.costmanagement.fluent.ScheduledActionsClient;
import com.azure.resourcemanager.costmanagement.fluent.ViewsClient;
import com.azure.resourcemanager.costmanagement.implementation.AlertsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.BenefitRecommendationsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.BenefitUtilizationSummariesClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientBuilder;
import com.azure.resourcemanager.costmanagement.implementation.DimensionsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.ExportsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.ForecastsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateCostDetailsReportsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportOperationResultsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportOperationStatusClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateReservationDetailsReportsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.OperationsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.PriceSheetsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.QueriesClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.ScheduledActionsClientImpl;
import com.azure.resourcemanager.costmanagement.implementation.ViewsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CostManagementClientBuilder.class)
public final class CostManagementClientImpl
implements CostManagementClient {
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final ViewsClient views;
    private final AlertsClient alerts;
    private final ForecastsClient forecasts;
    private final DimensionsClient dimensions;
    private final QueriesClient queries;
    private final GenerateReservationDetailsReportsClient generateReservationDetailsReports;
    private final ExportsClient exports;
    private final GenerateCostDetailsReportsClient generateCostDetailsReports;
    private final GenerateDetailedCostReportsClient generateDetailedCostReports;
    private final GenerateDetailedCostReportOperationResultsClient generateDetailedCostReportOperationResults;
    private final GenerateDetailedCostReportOperationStatusClient generateDetailedCostReportOperationStatus;
    private final PriceSheetsClient priceSheets;
    private final ScheduledActionsClient scheduledActions;
    private final BenefitRecommendationsClient benefitRecommendations;
    private final BenefitUtilizationSummariesClient benefitUtilizationSummaries;
    private static final ClientLogger LOGGER = new ClientLogger(CostManagementClientImpl.class);

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public ViewsClient getViews() {
        return this.views;
    }

    @Override
    public AlertsClient getAlerts() {
        return this.alerts;
    }

    @Override
    public ForecastsClient getForecasts() {
        return this.forecasts;
    }

    @Override
    public DimensionsClient getDimensions() {
        return this.dimensions;
    }

    @Override
    public QueriesClient getQueries() {
        return this.queries;
    }

    @Override
    public GenerateReservationDetailsReportsClient getGenerateReservationDetailsReports() {
        return this.generateReservationDetailsReports;
    }

    @Override
    public ExportsClient getExports() {
        return this.exports;
    }

    @Override
    public GenerateCostDetailsReportsClient getGenerateCostDetailsReports() {
        return this.generateCostDetailsReports;
    }

    @Override
    public GenerateDetailedCostReportsClient getGenerateDetailedCostReports() {
        return this.generateDetailedCostReports;
    }

    @Override
    public GenerateDetailedCostReportOperationResultsClient getGenerateDetailedCostReportOperationResults() {
        return this.generateDetailedCostReportOperationResults;
    }

    @Override
    public GenerateDetailedCostReportOperationStatusClient getGenerateDetailedCostReportOperationStatus() {
        return this.generateDetailedCostReportOperationStatus;
    }

    @Override
    public PriceSheetsClient getPriceSheets() {
        return this.priceSheets;
    }

    @Override
    public ScheduledActionsClient getScheduledActions() {
        return this.scheduledActions;
    }

    @Override
    public BenefitRecommendationsClient getBenefitRecommendations() {
        return this.benefitRecommendations;
    }

    @Override
    public BenefitUtilizationSummariesClient getBenefitUtilizationSummaries() {
        return this.benefitUtilizationSummaries;
    }

    CostManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.apiVersion = "2022-10-01";
        this.operations = new OperationsClientImpl(this);
        this.views = new ViewsClientImpl(this);
        this.alerts = new AlertsClientImpl(this);
        this.forecasts = new ForecastsClientImpl(this);
        this.dimensions = new DimensionsClientImpl(this);
        this.queries = new QueriesClientImpl(this);
        this.generateReservationDetailsReports = new GenerateReservationDetailsReportsClientImpl(this);
        this.exports = new ExportsClientImpl(this);
        this.generateCostDetailsReports = new GenerateCostDetailsReportsClientImpl(this);
        this.generateDetailedCostReports = new GenerateDetailedCostReportsClientImpl(this);
        this.generateDetailedCostReportOperationResults = new GenerateDetailedCostReportOperationResultsClientImpl(this);
        this.generateDetailedCostReportOperationStatus = new GenerateDetailedCostReportOperationStatusClientImpl(this);
        this.priceSheets = new PriceSheetsClientImpl(this);
        this.scheduledActions = new ScheduledActionsClientImpl(this);
        this.benefitRecommendations = new BenefitRecommendationsClientImpl(this);
        this.benefitUtilizationSummaries = new BenefitUtilizationSummariesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

