/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.DimensionsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.DimensionInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import com.azure.resourcemanager.costmanagement.models.DimensionsListResult;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;
import reactor.core.publisher.Mono;

public final class DimensionsClientImpl
implements DimensionsClient {
    private final DimensionsService service;
    private final CostManagementClientImpl client;

    DimensionsClientImpl(CostManagementClientImpl client) {
        this.service = (DimensionsService)RestProxy.create(DimensionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DimensionInner>> listSinglePageAsync(String scope, String filter, String expand, String skiptoken, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), scope, this.client.getApiVersion(), filter, expand, skiptoken, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DimensionsListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DimensionInner>> listSinglePageAsync(String scope, String filter, String expand, String skiptoken, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), scope, this.client.getApiVersion(), filter, expand, skiptoken, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DimensionsListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> listAsync(String scope, String filter, String expand, String skiptoken, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(scope, filter, expand, skiptoken, top));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> listAsync(String scope) {
        String filter = null;
        String expand = null;
        String skiptoken = null;
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(scope, filter, expand, skiptoken, top));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> listAsync(String scope, String filter, String expand, String skiptoken, Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(scope, filter, expand, skiptoken, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DimensionInner> list(String scope) {
        String filter = null;
        String expand = null;
        String skiptoken = null;
        Integer top = null;
        return new PagedIterable(this.listAsync(scope, filter, expand, skiptoken, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DimensionInner> list(String scope, String filter, String expand, String skiptoken, Integer top, Context context) {
        return new PagedIterable(this.listAsync(scope, filter, expand, skiptoken, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DimensionInner>> byExternalCloudProviderTypeSinglePageAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, String filter, String expand, String skiptoken, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.byExternalCloudProviderType(this.client.getEndpoint(), externalCloudProviderType, externalCloudProviderId, this.client.getApiVersion(), filter, expand, skiptoken, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DimensionsListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DimensionInner>> byExternalCloudProviderTypeSinglePageAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, String filter, String expand, String skiptoken, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.byExternalCloudProviderType(this.client.getEndpoint(), externalCloudProviderType, externalCloudProviderId, this.client.getApiVersion(), filter, expand, skiptoken, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DimensionsListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> byExternalCloudProviderTypeAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, String filter, String expand, String skiptoken, Integer top) {
        return new PagedFlux(() -> this.byExternalCloudProviderTypeSinglePageAsync(externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> byExternalCloudProviderTypeAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        String filter = null;
        String expand = null;
        String skiptoken = null;
        Integer top = null;
        return new PagedFlux(() -> this.byExternalCloudProviderTypeSinglePageAsync(externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> byExternalCloudProviderTypeAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, String filter, String expand, String skiptoken, Integer top, Context context) {
        return new PagedFlux(() -> this.byExternalCloudProviderTypeSinglePageAsync(externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DimensionInner> byExternalCloudProviderType(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        String filter = null;
        String expand = null;
        String skiptoken = null;
        Integer top = null;
        return new PagedIterable(this.byExternalCloudProviderTypeAsync(externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DimensionInner> byExternalCloudProviderType(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, String filter, String expand, String skiptoken, Integer top, Context context) {
        return new PagedIterable(this.byExternalCloudProviderTypeAsync(externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface DimensionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.CostManagement/dimensions")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DimensionsListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$expand") String var5, @QueryParam(value="$skiptoken") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.CostManagement/{externalCloudProviderType}/{externalCloudProviderId}/dimensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DimensionsListResult>> byExternalCloudProviderType(@HostParam(value="$host") String var1, @PathParam(value="externalCloudProviderType") ExternalCloudProviderType var2, @PathParam(value="externalCloudProviderId") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$expand") String var6, @QueryParam(value="$skiptoken") String var7, @QueryParam(value="$top") Integer var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

