/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.DimensionsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.DimensionInner;
import com.azure.resourcemanager.costmanagement.implementation.DimensionImpl;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.models.Dimension;
import com.azure.resourcemanager.costmanagement.models.Dimensions;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;

public final class DimensionsImpl
implements Dimensions {
    private static final ClientLogger LOGGER = new ClientLogger(DimensionsImpl.class);
    private final DimensionsClient innerClient;
    private final CostManagementManager serviceManager;

    public DimensionsImpl(DimensionsClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Dimension> list(String scope) {
        PagedIterable<DimensionInner> inner = this.serviceClient().list(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DimensionImpl((DimensionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Dimension> list(String scope, String filter, String expand, String skiptoken, Integer top, Context context) {
        PagedIterable<DimensionInner> inner = this.serviceClient().list(scope, filter, expand, skiptoken, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DimensionImpl((DimensionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Dimension> byExternalCloudProviderType(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        PagedIterable<DimensionInner> inner = this.serviceClient().byExternalCloudProviderType(externalCloudProviderType, externalCloudProviderId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DimensionImpl((DimensionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Dimension> byExternalCloudProviderType(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, String filter, String expand, String skiptoken, Integer top, Context context) {
        PagedIterable<DimensionInner> inner = this.serviceClient().byExternalCloudProviderType(externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DimensionImpl((DimensionInner)((Object)inner1), this.manager()));
    }

    private DimensionsClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }
}

