/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportExecutionListResultInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportInner;
import com.azure.resourcemanager.costmanagement.implementation.ExportExecutionListResultImpl;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.models.Export;
import com.azure.resourcemanager.costmanagement.models.ExportDefinition;
import com.azure.resourcemanager.costmanagement.models.ExportDeliveryInfo;
import com.azure.resourcemanager.costmanagement.models.ExportExecutionListResult;
import com.azure.resourcemanager.costmanagement.models.ExportSchedule;
import com.azure.resourcemanager.costmanagement.models.FormatType;
import java.time.OffsetDateTime;

public final class ExportImpl
implements Export,
Export.Definition,
Export.Update {
    private ExportInner innerObject;
    private final CostManagementManager serviceManager;
    private String scope;
    private String exportName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ExportSchedule schedule() {
        return this.innerModel().schedule();
    }

    @Override
    public FormatType format() {
        return this.innerModel().format();
    }

    @Override
    public ExportDeliveryInfo deliveryInfo() {
        return this.innerModel().deliveryInfo();
    }

    @Override
    public ExportDefinition definition() {
        return this.innerModel().definition();
    }

    @Override
    public ExportExecutionListResult runHistory() {
        ExportExecutionListResultInner inner = this.innerModel().runHistory();
        if (inner != null) {
            return new ExportExecutionListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Boolean partitionData() {
        return this.innerModel().partitionData();
    }

    @Override
    public OffsetDateTime nextRunTimeEstimate() {
        return this.innerModel().nextRunTimeEstimate();
    }

    @Override
    public ExportInner innerModel() {
        return this.innerObject;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ExportImpl withExistingScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public Export create() {
        this.innerObject = (ExportInner)((Object)this.serviceManager.serviceClient().getExports().createOrUpdateWithResponse(this.scope, this.exportName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Export create(Context context) {
        this.innerObject = (ExportInner)((Object)this.serviceManager.serviceClient().getExports().createOrUpdateWithResponse(this.scope, this.exportName, this.innerModel(), context).getValue());
        return this;
    }

    ExportImpl(String name, CostManagementManager serviceManager) {
        this.innerObject = new ExportInner();
        this.serviceManager = serviceManager;
        this.exportName = name;
    }

    @Override
    public ExportImpl update() {
        return this;
    }

    @Override
    public Export apply() {
        this.innerObject = (ExportInner)((Object)this.serviceManager.serviceClient().getExports().createOrUpdateWithResponse(this.scope, this.exportName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Export apply(Context context) {
        this.innerObject = (ExportInner)((Object)this.serviceManager.serviceClient().getExports().createOrUpdateWithResponse(this.scope, this.exportName, this.innerModel(), context).getValue());
        return this;
    }

    ExportImpl(ExportInner innerObject, CostManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.scope = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.CostManagement/exports/{exportName}", "scope");
        this.exportName = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.CostManagement/exports/{exportName}", "exportName");
    }

    @Override
    public Export refresh() {
        String localExpand = null;
        this.innerObject = (ExportInner)((Object)this.serviceManager.serviceClient().getExports().getWithResponse(this.scope, this.exportName, localExpand, Context.NONE).getValue());
        return this;
    }

    @Override
    public Export refresh(Context context) {
        String localExpand = null;
        this.innerObject = (ExportInner)((Object)this.serviceManager.serviceClient().getExports().getWithResponse(this.scope, this.exportName, localExpand, context).getValue());
        return this;
    }

    @Override
    public Response<Void> executeWithResponse(Context context) {
        return this.serviceManager.exports().executeWithResponse(this.scope, this.exportName, context);
    }

    @Override
    public void execute() {
        this.serviceManager.exports().execute(this.scope, this.exportName);
    }

    @Override
    public ExportImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public ExportImpl withSchedule(ExportSchedule schedule) {
        this.innerModel().withSchedule(schedule);
        return this;
    }

    @Override
    public ExportImpl withFormat(FormatType format) {
        this.innerModel().withFormat(format);
        return this;
    }

    @Override
    public ExportImpl withDeliveryInfo(ExportDeliveryInfo deliveryInfo) {
        this.innerModel().withDeliveryInfo(deliveryInfo);
        return this;
    }

    @Override
    public ExportImpl withDefinition(ExportDefinition definition) {
        this.innerModel().withDefinition(definition);
        return this;
    }

    @Override
    public ExportImpl withRunHistory(ExportExecutionListResultInner runHistory) {
        this.innerModel().withRunHistory(runHistory);
        return this;
    }

    @Override
    public ExportImpl withPartitionData(Boolean partitionData) {
        this.innerModel().withPartitionData(partitionData);
        return this;
    }
}

