/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.ForecastsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.ForecastResultInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;
import com.azure.resourcemanager.costmanagement.models.ForecastDefinition;
import reactor.core.publisher.Mono;

public final class ForecastsClientImpl
implements ForecastsClient {
    private final ForecastsService service;
    private final CostManagementClientImpl client;

    ForecastsClientImpl(CostManagementClientImpl client) {
        this.service = (ForecastsService)RestProxy.create(ForecastsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ForecastResultInner>> usageWithResponseAsync(String scope, ForecastDefinition parameters, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.usage(this.client.getEndpoint(), filter, this.client.getApiVersion(), scope, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ForecastResultInner>> usageWithResponseAsync(String scope, ForecastDefinition parameters, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.usage(this.client.getEndpoint(), filter, this.client.getApiVersion(), scope, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ForecastResultInner> usageAsync(String scope, ForecastDefinition parameters) {
        String filter = null;
        return this.usageWithResponseAsync(scope, parameters, filter).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ForecastResultInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ForecastResultInner> usageWithResponse(String scope, ForecastDefinition parameters, String filter, Context context) {
        return (Response)this.usageWithResponseAsync(scope, parameters, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ForecastResultInner usage(String scope, ForecastDefinition parameters) {
        String filter = null;
        return (ForecastResultInner)((Object)this.usageWithResponse(scope, parameters, filter, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ForecastResultInner>> externalCloudProviderUsageWithResponseAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, ForecastDefinition parameters, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.externalCloudProviderUsage(this.client.getEndpoint(), filter, this.client.getApiVersion(), externalCloudProviderType, externalCloudProviderId, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ForecastResultInner>> externalCloudProviderUsageWithResponseAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, ForecastDefinition parameters, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.externalCloudProviderUsage(this.client.getEndpoint(), filter, this.client.getApiVersion(), externalCloudProviderType, externalCloudProviderId, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ForecastResultInner> externalCloudProviderUsageAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, ForecastDefinition parameters) {
        String filter = null;
        return this.externalCloudProviderUsageWithResponseAsync(externalCloudProviderType, externalCloudProviderId, parameters, filter).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ForecastResultInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ForecastResultInner> externalCloudProviderUsageWithResponse(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, ForecastDefinition parameters, String filter, Context context) {
        return (Response)this.externalCloudProviderUsageWithResponseAsync(externalCloudProviderType, externalCloudProviderId, parameters, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ForecastResultInner externalCloudProviderUsage(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, ForecastDefinition parameters) {
        String filter = null;
        return (ForecastResultInner)((Object)this.externalCloudProviderUsageWithResponse(externalCloudProviderType, externalCloudProviderId, parameters, filter, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface ForecastsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.CostManagement/forecast")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ForecastResultInner>> usage(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="scope", encoded=true) String var4, @BodyParam(value="application/json") ForecastDefinition var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.CostManagement/{externalCloudProviderType}/{externalCloudProviderId}/forecast")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ForecastResultInner>> externalCloudProviderUsage(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="externalCloudProviderType") ExternalCloudProviderType var4, @PathParam(value="externalCloudProviderId") String var5, @BodyParam(value="application/json") ForecastDefinition var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

