/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.ForecastsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.ForecastResultInner;
import com.azure.resourcemanager.costmanagement.implementation.ForecastResultImpl;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;
import com.azure.resourcemanager.costmanagement.models.ForecastDefinition;
import com.azure.resourcemanager.costmanagement.models.ForecastResult;
import com.azure.resourcemanager.costmanagement.models.Forecasts;

public final class ForecastsImpl
implements Forecasts {
    private static final ClientLogger LOGGER = new ClientLogger(ForecastsImpl.class);
    private final ForecastsClient innerClient;
    private final CostManagementManager serviceManager;

    public ForecastsImpl(ForecastsClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ForecastResult> usageWithResponse(String scope, ForecastDefinition parameters, String filter, Context context) {
        Response<ForecastResultInner> inner = this.serviceClient().usageWithResponse(scope, parameters, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ForecastResultImpl((ForecastResultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ForecastResult usage(String scope, ForecastDefinition parameters) {
        ForecastResultInner inner = this.serviceClient().usage(scope, parameters);
        if (inner != null) {
            return new ForecastResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ForecastResult> externalCloudProviderUsageWithResponse(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, ForecastDefinition parameters, String filter, Context context) {
        Response<ForecastResultInner> inner = this.serviceClient().externalCloudProviderUsageWithResponse(externalCloudProviderType, externalCloudProviderId, parameters, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ForecastResultImpl((ForecastResultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ForecastResult externalCloudProviderUsage(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, ForecastDefinition parameters) {
        ForecastResultInner inner = this.serviceClient().externalCloudProviderUsage(externalCloudProviderType, externalCloudProviderId, parameters);
        if (inner != null) {
            return new ForecastResultImpl(inner, this.manager());
        }
        return null;
    }

    private ForecastsClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }
}

