/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.GenerateCostDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.CostDetailsOperationResultsInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GenerateCostDetailsReportsClientImpl
implements GenerateCostDetailsReportsClient {
    private final GenerateCostDetailsReportsService service;
    private final CostManagementClientImpl client;

    GenerateCostDetailsReportsClientImpl(CostManagementClientImpl client) {
        this.service = (GenerateCostDetailsReportsService)RestProxy.create(GenerateCostDetailsReportsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOperationWithResponseAsync(String scope, GenerateCostDetailsReportRequestDefinition parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOperation(this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOperationWithResponseAsync(String scope, GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOperation(this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginCreateOperationAsync(String scope, GenerateCostDetailsReportRequestDefinition parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOperationWithResponseAsync(scope, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CostDetailsOperationResultsInner.class), (Type)((Object)CostDetailsOperationResultsInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginCreateOperationAsync(String scope, GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOperationWithResponseAsync(scope, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CostDetailsOperationResultsInner.class), (Type)((Object)CostDetailsOperationResultsInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginCreateOperation(String scope, GenerateCostDetailsReportRequestDefinition parameters) {
        return this.beginCreateOperationAsync(scope, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginCreateOperation(String scope, GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        return this.beginCreateOperationAsync(scope, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CostDetailsOperationResultsInner> createOperationAsync(String scope, GenerateCostDetailsReportRequestDefinition parameters) {
        return this.beginCreateOperationAsync(scope, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CostDetailsOperationResultsInner> createOperationAsync(String scope, GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        return this.beginCreateOperationAsync(scope, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CostDetailsOperationResultsInner createOperation(String scope, GenerateCostDetailsReportRequestDefinition parameters) {
        return (CostDetailsOperationResultsInner)this.createOperationAsync(scope, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CostDetailsOperationResultsInner createOperation(String scope, GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        return (CostDetailsOperationResultsInner)this.createOperationAsync(scope, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getOperationResultsWithResponseAsync(String scope, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperationResults(this.client.getEndpoint(), scope, operationId, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getOperationResultsWithResponseAsync(String scope, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getOperationResults(this.client.getEndpoint(), scope, operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginGetOperationResultsAsync(String scope, String operationId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.getOperationResultsWithResponseAsync(scope, operationId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CostDetailsOperationResultsInner.class), (Type)((Object)CostDetailsOperationResultsInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginGetOperationResultsAsync(String scope, String operationId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.getOperationResultsWithResponseAsync(scope, operationId, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CostDetailsOperationResultsInner.class), (Type)((Object)CostDetailsOperationResultsInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginGetOperationResults(String scope, String operationId) {
        return this.beginGetOperationResultsAsync(scope, operationId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginGetOperationResults(String scope, String operationId, Context context) {
        return this.beginGetOperationResultsAsync(scope, operationId, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CostDetailsOperationResultsInner> getOperationResultsAsync(String scope, String operationId) {
        return this.beginGetOperationResultsAsync(scope, operationId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CostDetailsOperationResultsInner> getOperationResultsAsync(String scope, String operationId, Context context) {
        return this.beginGetOperationResultsAsync(scope, operationId, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CostDetailsOperationResultsInner getOperationResults(String scope, String operationId) {
        return (CostDetailsOperationResultsInner)this.getOperationResultsAsync(scope, operationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CostDetailsOperationResultsInner getOperationResults(String scope, String operationId, Context context) {
        return (CostDetailsOperationResultsInner)this.getOperationResultsAsync(scope, operationId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface GenerateCostDetailsReportsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.CostManagement/generateCostDetailsReport")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOperation(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") GenerateCostDetailsReportRequestDefinition var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.CostManagement/costDetailsOperationResults/{operationId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> getOperationResults(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="operationId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

