/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationStatusClient;
import com.azure.resourcemanager.costmanagement.fluent.models.GenerateDetailedCostReportOperationStatusesInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import reactor.core.publisher.Mono;

public final class GenerateDetailedCostReportOperationStatusClientImpl
implements GenerateDetailedCostReportOperationStatusClient {
    private final GenerateDetailedCostReportOperationStatusService service;
    private final CostManagementClientImpl client;

    GenerateDetailedCostReportOperationStatusClientImpl(CostManagementClientImpl client) {
        this.service = (GenerateDetailedCostReportOperationStatusService)RestProxy.create(GenerateDetailedCostReportOperationStatusService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GenerateDetailedCostReportOperationStatusesInner>> getWithResponseAsync(String operationId, String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), operationId, scope, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GenerateDetailedCostReportOperationStatusesInner>> getWithResponseAsync(String operationId, String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), operationId, scope, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GenerateDetailedCostReportOperationStatusesInner> getAsync(String operationId, String scope) {
        return this.getWithResponseAsync(operationId, scope).flatMap(res -> Mono.justOrEmpty((Object)((GenerateDetailedCostReportOperationStatusesInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GenerateDetailedCostReportOperationStatusesInner> getWithResponse(String operationId, String scope, Context context) {
        return (Response)this.getWithResponseAsync(operationId, scope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenerateDetailedCostReportOperationStatusesInner get(String operationId, String scope) {
        return (GenerateDetailedCostReportOperationStatusesInner)this.getWithResponse(operationId, scope, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface GenerateDetailedCostReportOperationStatusService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.CostManagement/operationStatus/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GenerateDetailedCostReportOperationStatusesInner>> get(@HostParam(value="$host") String var1, @PathParam(value="operationId") String var2, @PathParam(value="scope", encoded=true) String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

