/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.GenerateDetailedCostReportOperationResultInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportDefinition;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GenerateDetailedCostReportsClientImpl
implements GenerateDetailedCostReportsClient {
    private final GenerateDetailedCostReportsService service;
    private final CostManagementClientImpl client;

    GenerateDetailedCostReportsClientImpl(CostManagementClientImpl client) {
        this.service = (GenerateDetailedCostReportsService)RestProxy.create(GenerateDetailedCostReportsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOperationWithResponseAsync(String scope, GenerateDetailedCostReportDefinition parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOperation(this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOperationWithResponseAsync(String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOperation(this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner> beginCreateOperationAsync(String scope, GenerateDetailedCostReportDefinition parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOperationWithResponseAsync(scope, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenerateDetailedCostReportOperationResultInner.class), (Type)((Object)GenerateDetailedCostReportOperationResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner> beginCreateOperationAsync(String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOperationWithResponseAsync(scope, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenerateDetailedCostReportOperationResultInner.class), (Type)((Object)GenerateDetailedCostReportOperationResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner> beginCreateOperation(String scope, GenerateDetailedCostReportDefinition parameters) {
        return this.beginCreateOperationAsync(scope, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner> beginCreateOperation(String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        return this.beginCreateOperationAsync(scope, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GenerateDetailedCostReportOperationResultInner> createOperationAsync(String scope, GenerateDetailedCostReportDefinition parameters) {
        return this.beginCreateOperationAsync(scope, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GenerateDetailedCostReportOperationResultInner> createOperationAsync(String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        return this.beginCreateOperationAsync(scope, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenerateDetailedCostReportOperationResultInner createOperation(String scope, GenerateDetailedCostReportDefinition parameters) {
        return (GenerateDetailedCostReportOperationResultInner)this.createOperationAsync(scope, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenerateDetailedCostReportOperationResultInner createOperation(String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        return (GenerateDetailedCostReportOperationResultInner)this.createOperationAsync(scope, parameters, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface GenerateDetailedCostReportsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.CostManagement/generateDetailedCostReport")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOperation(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") GenerateDetailedCostReportDefinition var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

