/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.GenerateReservationDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.OperationStatusInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GenerateReservationDetailsReportsClientImpl
implements GenerateReservationDetailsReportsClient {
    private final GenerateReservationDetailsReportsService service;
    private final CostManagementClientImpl client;

    GenerateReservationDetailsReportsClientImpl(CostManagementClientImpl client) {
        this.service = (GenerateReservationDetailsReportsService)RestProxy.create(GenerateReservationDetailsReportsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> byBillingAccountIdWithResponseAsync(String billingAccountId, String startDate, String endDate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        if (startDate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter startDate is required and cannot be null."));
        }
        if (endDate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endDate is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.byBillingAccountId(this.client.getEndpoint(), billingAccountId, startDate, endDate, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> byBillingAccountIdWithResponseAsync(String billingAccountId, String startDate, String endDate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        if (startDate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter startDate is required and cannot be null."));
        }
        if (endDate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endDate is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.byBillingAccountId(this.client.getEndpoint(), billingAccountId, startDate, endDate, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusInner>, OperationStatusInner> beginByBillingAccountIdAsync(String billingAccountId, String startDate, String endDate) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.byBillingAccountIdWithResponseAsync(billingAccountId, startDate, endDate);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusInner.class), (Type)((Object)OperationStatusInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusInner>, OperationStatusInner> beginByBillingAccountIdAsync(String billingAccountId, String startDate, String endDate, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.byBillingAccountIdWithResponseAsync(billingAccountId, startDate, endDate, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusInner.class), (Type)((Object)OperationStatusInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusInner>, OperationStatusInner> beginByBillingAccountId(String billingAccountId, String startDate, String endDate) {
        return this.beginByBillingAccountIdAsync(billingAccountId, startDate, endDate).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusInner>, OperationStatusInner> beginByBillingAccountId(String billingAccountId, String startDate, String endDate, Context context) {
        return this.beginByBillingAccountIdAsync(billingAccountId, startDate, endDate, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusInner> byBillingAccountIdAsync(String billingAccountId, String startDate, String endDate) {
        return this.beginByBillingAccountIdAsync(billingAccountId, startDate, endDate).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusInner> byBillingAccountIdAsync(String billingAccountId, String startDate, String endDate, Context context) {
        return this.beginByBillingAccountIdAsync(billingAccountId, startDate, endDate, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusInner byBillingAccountId(String billingAccountId, String startDate, String endDate) {
        return (OperationStatusInner)this.byBillingAccountIdAsync(billingAccountId, startDate, endDate).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusInner byBillingAccountId(String billingAccountId, String startDate, String endDate, Context context) {
        return (OperationStatusInner)this.byBillingAccountIdAsync(billingAccountId, startDate, endDate, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> byBillingProfileIdWithResponseAsync(String billingAccountId, String billingProfileId, String startDate, String endDate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        if (billingProfileId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingProfileId is required and cannot be null."));
        }
        if (startDate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter startDate is required and cannot be null."));
        }
        if (endDate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endDate is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.byBillingProfileId(this.client.getEndpoint(), billingAccountId, billingProfileId, startDate, endDate, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> byBillingProfileIdWithResponseAsync(String billingAccountId, String billingProfileId, String startDate, String endDate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        if (billingProfileId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingProfileId is required and cannot be null."));
        }
        if (startDate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter startDate is required and cannot be null."));
        }
        if (endDate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endDate is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.byBillingProfileId(this.client.getEndpoint(), billingAccountId, billingProfileId, startDate, endDate, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusInner>, OperationStatusInner> beginByBillingProfileIdAsync(String billingAccountId, String billingProfileId, String startDate, String endDate) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.byBillingProfileIdWithResponseAsync(billingAccountId, billingProfileId, startDate, endDate);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusInner.class), (Type)((Object)OperationStatusInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusInner>, OperationStatusInner> beginByBillingProfileIdAsync(String billingAccountId, String billingProfileId, String startDate, String endDate, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.byBillingProfileIdWithResponseAsync(billingAccountId, billingProfileId, startDate, endDate, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusInner.class), (Type)((Object)OperationStatusInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusInner>, OperationStatusInner> beginByBillingProfileId(String billingAccountId, String billingProfileId, String startDate, String endDate) {
        return this.beginByBillingProfileIdAsync(billingAccountId, billingProfileId, startDate, endDate).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusInner>, OperationStatusInner> beginByBillingProfileId(String billingAccountId, String billingProfileId, String startDate, String endDate, Context context) {
        return this.beginByBillingProfileIdAsync(billingAccountId, billingProfileId, startDate, endDate, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusInner> byBillingProfileIdAsync(String billingAccountId, String billingProfileId, String startDate, String endDate) {
        return this.beginByBillingProfileIdAsync(billingAccountId, billingProfileId, startDate, endDate).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusInner> byBillingProfileIdAsync(String billingAccountId, String billingProfileId, String startDate, String endDate, Context context) {
        return this.beginByBillingProfileIdAsync(billingAccountId, billingProfileId, startDate, endDate, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusInner byBillingProfileId(String billingAccountId, String billingProfileId, String startDate, String endDate) {
        return (OperationStatusInner)this.byBillingProfileIdAsync(billingAccountId, billingProfileId, startDate, endDate).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusInner byBillingProfileId(String billingAccountId, String billingProfileId, String startDate, String endDate, Context context) {
        return (OperationStatusInner)this.byBillingProfileIdAsync(billingAccountId, billingProfileId, startDate, endDate, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface GenerateReservationDetailsReportsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/generateReservationDetailsReport")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> byBillingAccountId(@HostParam(value="$host") String var1, @PathParam(value="billingAccountId") String var2, @QueryParam(value="startDate") String var3, @QueryParam(value="endDate") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/providers/Microsoft.CostManagement/generateReservationDetailsReport")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> byBillingProfileId(@HostParam(value="$host") String var1, @PathParam(value="billingAccountId") String var2, @PathParam(value="billingProfileId") String var3, @QueryParam(value="startDate") String var4, @QueryParam(value="endDate") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

