/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.OperationsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.CostManagementOperationInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementOperationImpl;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.models.CostManagementOperation;
import com.azure.resourcemanager.costmanagement.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final CostManagementManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CostManagementOperation> list() {
        PagedIterable<CostManagementOperationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CostManagementOperationImpl((CostManagementOperationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<CostManagementOperation> list(Context context) {
        PagedIterable<CostManagementOperationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CostManagementOperationImpl((CostManagementOperationInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }
}

