/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.PriceSheetsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.DownloadUrlInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PriceSheetsClientImpl
implements PriceSheetsClient {
    private final PriceSheetsService service;
    private final CostManagementClientImpl client;

    PriceSheetsClientImpl(CostManagementClientImpl client) {
        this.service = (PriceSheetsService)RestProxy.create(PriceSheetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadWithResponseAsync(String billingAccountName, String billingProfileName, String invoiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountName is required and cannot be null."));
        }
        if (billingProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingProfileName is required and cannot be null."));
        }
        if (invoiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter invoiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.download(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountName, billingProfileName, invoiceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadWithResponseAsync(String billingAccountName, String billingProfileName, String invoiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountName is required and cannot be null."));
        }
        if (billingProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingProfileName is required and cannot be null."));
        }
        if (invoiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter invoiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.download(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountName, billingProfileName, invoiceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownloadAsync(String billingAccountName, String billingProfileName, String invoiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.downloadWithResponseAsync(billingAccountName, billingProfileName, invoiceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DownloadUrlInner.class), (Type)((Object)DownloadUrlInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownloadAsync(String billingAccountName, String billingProfileName, String invoiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.downloadWithResponseAsync(billingAccountName, billingProfileName, invoiceName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DownloadUrlInner.class), (Type)((Object)DownloadUrlInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownload(String billingAccountName, String billingProfileName, String invoiceName) {
        return this.beginDownloadAsync(billingAccountName, billingProfileName, invoiceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownload(String billingAccountName, String billingProfileName, String invoiceName, Context context) {
        return this.beginDownloadAsync(billingAccountName, billingProfileName, invoiceName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DownloadUrlInner> downloadAsync(String billingAccountName, String billingProfileName, String invoiceName) {
        return this.beginDownloadAsync(billingAccountName, billingProfileName, invoiceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DownloadUrlInner> downloadAsync(String billingAccountName, String billingProfileName, String invoiceName, Context context) {
        return this.beginDownloadAsync(billingAccountName, billingProfileName, invoiceName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DownloadUrlInner download(String billingAccountName, String billingProfileName, String invoiceName) {
        return (DownloadUrlInner)this.downloadAsync(billingAccountName, billingProfileName, invoiceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DownloadUrlInner download(String billingAccountName, String billingProfileName, String invoiceName, Context context) {
        return (DownloadUrlInner)this.downloadAsync(billingAccountName, billingProfileName, invoiceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadByBillingProfileWithResponseAsync(String billingAccountName, String billingProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountName is required and cannot be null."));
        }
        if (billingProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingProfileName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.downloadByBillingProfile(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountName, billingProfileName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadByBillingProfileWithResponseAsync(String billingAccountName, String billingProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingAccountName is required and cannot be null."));
        }
        if (billingProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingProfileName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.downloadByBillingProfile(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountName, billingProfileName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownloadByBillingProfileAsync(String billingAccountName, String billingProfileName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.downloadByBillingProfileWithResponseAsync(billingAccountName, billingProfileName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DownloadUrlInner.class), (Type)((Object)DownloadUrlInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownloadByBillingProfileAsync(String billingAccountName, String billingProfileName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.downloadByBillingProfileWithResponseAsync(billingAccountName, billingProfileName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DownloadUrlInner.class), (Type)((Object)DownloadUrlInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownloadByBillingProfile(String billingAccountName, String billingProfileName) {
        return this.beginDownloadByBillingProfileAsync(billingAccountName, billingProfileName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownloadByBillingProfile(String billingAccountName, String billingProfileName, Context context) {
        return this.beginDownloadByBillingProfileAsync(billingAccountName, billingProfileName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DownloadUrlInner> downloadByBillingProfileAsync(String billingAccountName, String billingProfileName) {
        return this.beginDownloadByBillingProfileAsync(billingAccountName, billingProfileName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DownloadUrlInner> downloadByBillingProfileAsync(String billingAccountName, String billingProfileName, Context context) {
        return this.beginDownloadByBillingProfileAsync(billingAccountName, billingProfileName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DownloadUrlInner downloadByBillingProfile(String billingAccountName, String billingProfileName) {
        return (DownloadUrlInner)this.downloadByBillingProfileAsync(billingAccountName, billingProfileName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DownloadUrlInner downloadByBillingProfile(String billingAccountName, String billingProfileName, Context context) {
        return (DownloadUrlInner)this.downloadByBillingProfileAsync(billingAccountName, billingProfileName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface PriceSheetsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoices/{invoiceName}/providers/Microsoft.CostManagement/pricesheets/default/download")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> download(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="billingAccountName") String var3, @PathParam(value="billingProfileName") String var4, @PathParam(value="invoiceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/providers/Microsoft.CostManagement/pricesheets/default/download")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> downloadByBillingProfile(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="billingAccountName") String var3, @PathParam(value="billingProfileName") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

