/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.QueriesClient;
import com.azure.resourcemanager.costmanagement.fluent.models.QueryResultInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;
import com.azure.resourcemanager.costmanagement.models.QueryDefinition;
import reactor.core.publisher.Mono;

public final class QueriesClientImpl
implements QueriesClient {
    private final QueriesService service;
    private final CostManagementClientImpl client;

    QueriesClientImpl(CostManagementClientImpl client) {
        this.service = (QueriesService)RestProxy.create(QueriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryResultInner>> usageWithResponseAsync(String scope, QueryDefinition parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.usage(this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryResultInner>> usageWithResponseAsync(String scope, QueryDefinition parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.usage(this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<QueryResultInner> usageAsync(String scope, QueryDefinition parameters) {
        return this.usageWithResponseAsync(scope, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((QueryResultInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueryResultInner> usageWithResponse(String scope, QueryDefinition parameters, Context context) {
        return (Response)this.usageWithResponseAsync(scope, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueryResultInner usage(String scope, QueryDefinition parameters) {
        return (QueryResultInner)((Object)this.usageWithResponse(scope, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryResultInner>> usageByExternalCloudProviderTypeWithResponseAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, QueryDefinition parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.usageByExternalCloudProviderType(this.client.getEndpoint(), externalCloudProviderType, externalCloudProviderId, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryResultInner>> usageByExternalCloudProviderTypeWithResponseAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, QueryDefinition parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.usageByExternalCloudProviderType(this.client.getEndpoint(), externalCloudProviderType, externalCloudProviderId, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<QueryResultInner> usageByExternalCloudProviderTypeAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, QueryDefinition parameters) {
        return this.usageByExternalCloudProviderTypeWithResponseAsync(externalCloudProviderType, externalCloudProviderId, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((QueryResultInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueryResultInner> usageByExternalCloudProviderTypeWithResponse(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, QueryDefinition parameters, Context context) {
        return (Response)this.usageByExternalCloudProviderTypeWithResponseAsync(externalCloudProviderType, externalCloudProviderId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueryResultInner usageByExternalCloudProviderType(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, QueryDefinition parameters) {
        return (QueryResultInner)((Object)this.usageByExternalCloudProviderTypeWithResponse(externalCloudProviderType, externalCloudProviderId, parameters, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface QueriesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.CostManagement/query")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QueryResultInner>> usage(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") QueryDefinition var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.CostManagement/{externalCloudProviderType}/{externalCloudProviderId}/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QueryResultInner>> usageByExternalCloudProviderType(@HostParam(value="$host") String var1, @PathParam(value="externalCloudProviderType") ExternalCloudProviderType var2, @PathParam(value="externalCloudProviderId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") QueryDefinition var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

