/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.QueriesClient;
import com.azure.resourcemanager.costmanagement.fluent.models.QueryResultInner;
import com.azure.resourcemanager.costmanagement.implementation.QueryResultImpl;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;
import com.azure.resourcemanager.costmanagement.models.Queries;
import com.azure.resourcemanager.costmanagement.models.QueryDefinition;
import com.azure.resourcemanager.costmanagement.models.QueryResult;

public final class QueriesImpl
implements Queries {
    private static final ClientLogger LOGGER = new ClientLogger(QueriesImpl.class);
    private final QueriesClient innerClient;
    private final CostManagementManager serviceManager;

    public QueriesImpl(QueriesClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<QueryResult> usageWithResponse(String scope, QueryDefinition parameters, Context context) {
        Response<QueryResultInner> inner = this.serviceClient().usageWithResponse(scope, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new QueryResultImpl((QueryResultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public QueryResult usage(String scope, QueryDefinition parameters) {
        QueryResultInner inner = this.serviceClient().usage(scope, parameters);
        if (inner != null) {
            return new QueryResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<QueryResult> usageByExternalCloudProviderTypeWithResponse(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, QueryDefinition parameters, Context context) {
        Response<QueryResultInner> inner = this.serviceClient().usageByExternalCloudProviderTypeWithResponse(externalCloudProviderType, externalCloudProviderId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new QueryResultImpl((QueryResultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public QueryResult usageByExternalCloudProviderType(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, QueryDefinition parameters) {
        QueryResultInner inner = this.serviceClient().usageByExternalCloudProviderType(externalCloudProviderType, externalCloudProviderId, parameters);
        if (inner != null) {
            return new QueryResultImpl(inner, this.manager());
        }
        return null;
    }

    private QueriesClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }
}

