/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.models.ScheduledActionInner;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.models.FileDestination;
import com.azure.resourcemanager.costmanagement.models.NotificationProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduleProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduledAction;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionKind;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionStatus;

public final class ScheduledActionImpl
implements ScheduledAction,
ScheduledAction.Definition,
ScheduledAction.Update {
    private ScheduledActionInner innerObject;
    private final CostManagementManager serviceManager;
    private String scope;
    private String name;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ScheduledActionKind kind() {
        return this.innerModel().kind();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public FileDestination fileDestination() {
        return this.innerModel().fileDestination();
    }

    @Override
    public NotificationProperties notification() {
        return this.innerModel().notification();
    }

    @Override
    public String notificationEmail() {
        return this.innerModel().notificationEmail();
    }

    @Override
    public ScheduleProperties schedule() {
        return this.innerModel().schedule();
    }

    @Override
    public String scope() {
        return this.innerModel().scope();
    }

    @Override
    public ScheduledActionStatus status() {
        return this.innerModel().status();
    }

    @Override
    public String viewId() {
        return this.innerModel().viewId();
    }

    @Override
    public ScheduledActionInner innerModel() {
        return this.innerObject;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ScheduledActionImpl withExistingScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public ScheduledAction create() {
        this.innerObject = (ScheduledActionInner)((Object)this.serviceManager.serviceClient().getScheduledActions().createOrUpdateByScopeWithResponse(this.scope, this.name, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ScheduledAction create(Context context) {
        this.innerObject = (ScheduledActionInner)((Object)this.serviceManager.serviceClient().getScheduledActions().createOrUpdateByScopeWithResponse(this.scope, this.name, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    ScheduledActionImpl(String name, CostManagementManager serviceManager) {
        this.innerObject = new ScheduledActionInner();
        this.serviceManager = serviceManager;
        this.name = name;
        this.createIfMatch = null;
    }

    @Override
    public ScheduledActionImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public ScheduledAction apply() {
        this.innerObject = (ScheduledActionInner)((Object)this.serviceManager.serviceClient().getScheduledActions().createOrUpdateByScopeWithResponse(this.scope, this.name, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ScheduledAction apply(Context context) {
        this.innerObject = (ScheduledActionInner)((Object)this.serviceManager.serviceClient().getScheduledActions().createOrUpdateByScopeWithResponse(this.scope, this.name, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    ScheduledActionImpl(ScheduledActionInner innerObject, CostManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.scope = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        this.name = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
    }

    @Override
    public ScheduledAction refresh() {
        this.innerObject = (ScheduledActionInner)((Object)this.serviceManager.serviceClient().getScheduledActions().getByScopeWithResponse(this.scope, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public ScheduledAction refresh(Context context) {
        this.innerObject = (ScheduledActionInner)((Object)this.serviceManager.serviceClient().getScheduledActions().getByScopeWithResponse(this.scope, this.name, context).getValue());
        return this;
    }

    @Override
    public Response<Void> runByScopeWithResponse(Context context) {
        return this.serviceManager.scheduledActions().runByScopeWithResponse(this.scope, this.name, context);
    }

    @Override
    public void runByScope() {
        this.serviceManager.scheduledActions().runByScope(this.scope, this.name);
    }

    @Override
    public ScheduledActionImpl withKind(ScheduledActionKind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public ScheduledActionImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public ScheduledActionImpl withFileDestination(FileDestination fileDestination) {
        this.innerModel().withFileDestination(fileDestination);
        return this;
    }

    @Override
    public ScheduledActionImpl withNotification(NotificationProperties notification) {
        this.innerModel().withNotification(notification);
        return this;
    }

    @Override
    public ScheduledActionImpl withNotificationEmail(String notificationEmail) {
        this.innerModel().withNotificationEmail(notificationEmail);
        return this;
    }

    @Override
    public ScheduledActionImpl withSchedule(ScheduleProperties schedule) {
        this.innerModel().withSchedule(schedule);
        return this;
    }

    @Override
    public ScheduledActionImpl withScope(String scope) {
        this.innerModel().withScope(scope);
        return this;
    }

    @Override
    public ScheduledActionImpl withStatus(ScheduledActionStatus status) {
        this.innerModel().withStatus(status);
        return this;
    }

    @Override
    public ScheduledActionImpl withViewId(String viewId) {
        this.innerModel().withViewId(viewId);
        return this;
    }

    @Override
    public ScheduledActionImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

