/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.ScheduledActionsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.CheckNameAvailabilityResponseInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ScheduledActionInner;
import com.azure.resourcemanager.costmanagement.implementation.CheckNameAvailabilityResponseImpl;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.implementation.ScheduledActionImpl;
import com.azure.resourcemanager.costmanagement.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.costmanagement.models.CheckNameAvailabilityResponse;
import com.azure.resourcemanager.costmanagement.models.ScheduledAction;
import com.azure.resourcemanager.costmanagement.models.ScheduledActions;

public final class ScheduledActionsImpl
implements ScheduledActions {
    private static final ClientLogger LOGGER = new ClientLogger(ScheduledActionsImpl.class);
    private final ScheduledActionsClient innerClient;
    private final CostManagementManager serviceManager;

    public ScheduledActionsImpl(ScheduledActionsClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ScheduledAction> list() {
        PagedIterable<ScheduledActionInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ScheduledActionImpl((ScheduledActionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ScheduledAction> list(String filter, Context context) {
        PagedIterable<ScheduledActionInner> inner = this.serviceClient().list(filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ScheduledActionImpl((ScheduledActionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ScheduledAction> listByScope(String scope) {
        PagedIterable<ScheduledActionInner> inner = this.serviceClient().listByScope(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ScheduledActionImpl((ScheduledActionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ScheduledAction> listByScope(String scope, String filter, Context context) {
        PagedIterable<ScheduledActionInner> inner = this.serviceClient().listByScope(scope, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ScheduledActionImpl((ScheduledActionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ScheduledAction> createOrUpdateWithResponse(String name, ScheduledActionInner scheduledAction, String ifMatch, Context context) {
        Response<ScheduledActionInner> inner = this.serviceClient().createOrUpdateWithResponse(name, scheduledAction, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScheduledActionImpl((ScheduledActionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ScheduledAction createOrUpdate(String name, ScheduledActionInner scheduledAction) {
        ScheduledActionInner inner = this.serviceClient().createOrUpdate(name, scheduledAction);
        if (inner != null) {
            return new ScheduledActionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ScheduledAction> getWithResponse(String name, Context context) {
        Response<ScheduledActionInner> inner = this.serviceClient().getWithResponse(name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScheduledActionImpl((ScheduledActionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ScheduledAction get(String name) {
        ScheduledActionInner inner = this.serviceClient().get(name);
        if (inner != null) {
            return new ScheduledActionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String name, Context context) {
        return this.serviceClient().deleteWithResponse(name, context);
    }

    @Override
    public void delete(String name) {
        this.serviceClient().delete(name);
    }

    @Override
    public Response<ScheduledAction> getByScopeWithResponse(String scope, String name, Context context) {
        Response<ScheduledActionInner> inner = this.serviceClient().getByScopeWithResponse(scope, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScheduledActionImpl((ScheduledActionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ScheduledAction getByScope(String scope, String name) {
        ScheduledActionInner inner = this.serviceClient().getByScope(scope, name);
        if (inner != null) {
            return new ScheduledActionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByScopeWithResponse(String scope, String name, Context context) {
        return this.serviceClient().deleteByScopeWithResponse(scope, name, context);
    }

    @Override
    public void deleteByScope(String scope, String name) {
        this.serviceClient().deleteByScope(scope, name);
    }

    @Override
    public Response<Void> runWithResponse(String name, Context context) {
        return this.serviceClient().runWithResponse(name, context);
    }

    @Override
    public void run(String name) {
        this.serviceClient().run(name);
    }

    @Override
    public Response<Void> runByScopeWithResponse(String scope, String name, Context context) {
        return this.serviceClient().runByScopeWithResponse(scope, name, context);
    }

    @Override
    public void runByScope(String scope, String name) {
        this.serviceClient().runByScope(scope, name);
    }

    @Override
    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context) {
        Response<CheckNameAvailabilityResponseInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(checkNameAvailabilityRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResponseImpl((CheckNameAvailabilityResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResponse checkNameAvailability(CheckNameAvailabilityRequest checkNameAvailabilityRequest) {
        CheckNameAvailabilityResponseInner inner = this.serviceClient().checkNameAvailability(checkNameAvailabilityRequest);
        if (inner != null) {
            return new CheckNameAvailabilityResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityByScopeWithResponse(String scope, CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context) {
        Response<CheckNameAvailabilityResponseInner> inner = this.serviceClient().checkNameAvailabilityByScopeWithResponse(scope, checkNameAvailabilityRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResponseImpl((CheckNameAvailabilityResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResponse checkNameAvailabilityByScope(String scope, CheckNameAvailabilityRequest checkNameAvailabilityRequest) {
        CheckNameAvailabilityResponseInner inner = this.serviceClient().checkNameAvailabilityByScope(scope, checkNameAvailabilityRequest);
        if (inner != null) {
            return new CheckNameAvailabilityResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ScheduledAction getById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scheduledActions'.", id)));
        }
        return (ScheduledAction)this.getByScopeWithResponse(scope, name, Context.NONE).getValue();
    }

    @Override
    public Response<ScheduledAction> getByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scheduledActions'.", id)));
        }
        return this.getByScopeWithResponse(scope, name, context);
    }

    @Override
    public void deleteById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scheduledActions'.", id)));
        }
        this.deleteByScopeWithResponse(scope, name, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scheduledActions'.", id)));
        }
        return this.deleteByScopeWithResponse(scope, name, context);
    }

    private ScheduledActionsClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ScheduledActionImpl define(String name) {
        return new ScheduledActionImpl(name, this.manager());
    }
}

