/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.models.ViewInner;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.models.AccumulatedType;
import com.azure.resourcemanager.costmanagement.models.ChartType;
import com.azure.resourcemanager.costmanagement.models.KpiProperties;
import com.azure.resourcemanager.costmanagement.models.MetricType;
import com.azure.resourcemanager.costmanagement.models.PivotProperties;
import com.azure.resourcemanager.costmanagement.models.ReportConfigDataset;
import com.azure.resourcemanager.costmanagement.models.ReportConfigTimePeriod;
import com.azure.resourcemanager.costmanagement.models.ReportTimeframeType;
import com.azure.resourcemanager.costmanagement.models.ReportType;
import com.azure.resourcemanager.costmanagement.models.View;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;

public final class ViewImpl
implements View,
View.Definition,
View.Update {
    private ViewInner innerObject;
    private final CostManagementManager serviceManager;
    private String scope;
    private String viewName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String scope() {
        return this.innerModel().scope();
    }

    @Override
    public OffsetDateTime createdOn() {
        return this.innerModel().createdOn();
    }

    @Override
    public OffsetDateTime modifiedOn() {
        return this.innerModel().modifiedOn();
    }

    @Override
    public String dateRange() {
        return this.innerModel().dateRange();
    }

    @Override
    public String currency() {
        return this.innerModel().currency();
    }

    @Override
    public ChartType chart() {
        return this.innerModel().chart();
    }

    @Override
    public AccumulatedType accumulated() {
        return this.innerModel().accumulated();
    }

    @Override
    public MetricType metric() {
        return this.innerModel().metric();
    }

    @Override
    public List<KpiProperties> kpis() {
        List<KpiProperties> inner = this.innerModel().kpis();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<PivotProperties> pivots() {
        List<PivotProperties> inner = this.innerModel().pivots();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ReportType typePropertiesType() {
        return this.innerModel().typePropertiesType();
    }

    @Override
    public ReportTimeframeType timeframe() {
        return this.innerModel().timeframe();
    }

    @Override
    public ReportConfigTimePeriod timePeriod() {
        return this.innerModel().timePeriod();
    }

    @Override
    public ReportConfigDataset dataSet() {
        return this.innerModel().dataSet();
    }

    @Override
    public Boolean includeMonetaryCommitment() {
        return this.innerModel().includeMonetaryCommitment();
    }

    @Override
    public ViewInner innerModel() {
        return this.innerObject;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ViewImpl withExistingScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public View create() {
        this.innerObject = (ViewInner)((Object)this.serviceManager.serviceClient().getViews().createOrUpdateByScopeWithResponse(this.scope, this.viewName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public View create(Context context) {
        this.innerObject = (ViewInner)((Object)this.serviceManager.serviceClient().getViews().createOrUpdateByScopeWithResponse(this.scope, this.viewName, this.innerModel(), context).getValue());
        return this;
    }

    ViewImpl(String name, CostManagementManager serviceManager) {
        this.innerObject = new ViewInner();
        this.serviceManager = serviceManager;
        this.viewName = name;
    }

    @Override
    public ViewImpl update() {
        return this;
    }

    @Override
    public View apply() {
        this.innerObject = (ViewInner)((Object)this.serviceManager.serviceClient().getViews().createOrUpdateByScopeWithResponse(this.scope, this.viewName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public View apply(Context context) {
        this.innerObject = (ViewInner)((Object)this.serviceManager.serviceClient().getViews().createOrUpdateByScopeWithResponse(this.scope, this.viewName, this.innerModel(), context).getValue());
        return this;
    }

    ViewImpl(ViewInner innerObject, CostManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.scope = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "scope");
        this.viewName = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "viewName");
    }

    @Override
    public View refresh() {
        this.innerObject = (ViewInner)((Object)this.serviceManager.serviceClient().getViews().getByScopeWithResponse(this.scope, this.viewName, Context.NONE).getValue());
        return this;
    }

    @Override
    public View refresh(Context context) {
        this.innerObject = (ViewInner)((Object)this.serviceManager.serviceClient().getViews().getByScopeWithResponse(this.scope, this.viewName, context).getValue());
        return this;
    }

    @Override
    public ViewImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public ViewImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public ViewImpl withScope(String scope) {
        this.innerModel().withScope(scope);
        return this;
    }

    @Override
    public ViewImpl withDateRange(String dateRange) {
        this.innerModel().withDateRange(dateRange);
        return this;
    }

    @Override
    public ViewImpl withChart(ChartType chart) {
        this.innerModel().withChart(chart);
        return this;
    }

    @Override
    public ViewImpl withAccumulated(AccumulatedType accumulated) {
        this.innerModel().withAccumulated(accumulated);
        return this;
    }

    @Override
    public ViewImpl withMetric(MetricType metric) {
        this.innerModel().withMetric(metric);
        return this;
    }

    @Override
    public ViewImpl withKpis(List<KpiProperties> kpis) {
        this.innerModel().withKpis(kpis);
        return this;
    }

    @Override
    public ViewImpl withPivots(List<PivotProperties> pivots) {
        this.innerModel().withPivots(pivots);
        return this;
    }

    @Override
    public ViewImpl withTypePropertiesType(ReportType typePropertiesType) {
        this.innerModel().withTypePropertiesType(typePropertiesType);
        return this;
    }

    @Override
    public ViewImpl withTimeframe(ReportTimeframeType timeframe) {
        this.innerModel().withTimeframe(timeframe);
        return this;
    }

    @Override
    public ViewImpl withTimePeriod(ReportConfigTimePeriod timePeriod) {
        this.innerModel().withTimePeriod(timePeriod);
        return this;
    }

    @Override
    public ViewImpl withDataSet(ReportConfigDataset dataSet) {
        this.innerModel().withDataSet(dataSet);
        return this;
    }

    @Override
    public ViewImpl withIncludeMonetaryCommitment(Boolean includeMonetaryCommitment) {
        this.innerModel().withIncludeMonetaryCommitment(includeMonetaryCommitment);
        return this;
    }
}

