/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.ViewsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.ViewInner;
import com.azure.resourcemanager.costmanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.costmanagement.implementation.ViewImpl;
import com.azure.resourcemanager.costmanagement.models.View;
import com.azure.resourcemanager.costmanagement.models.Views;

public final class ViewsImpl
implements Views {
    private static final ClientLogger LOGGER = new ClientLogger(ViewsImpl.class);
    private final ViewsClient innerClient;
    private final CostManagementManager serviceManager;

    public ViewsImpl(ViewsClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<View> list() {
        PagedIterable<ViewInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ViewImpl((ViewInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<View> list(Context context) {
        PagedIterable<ViewInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ViewImpl((ViewInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<View> listByScope(String scope) {
        PagedIterable<ViewInner> inner = this.serviceClient().listByScope(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ViewImpl((ViewInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<View> listByScope(String scope, Context context) {
        PagedIterable<ViewInner> inner = this.serviceClient().listByScope(scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ViewImpl((ViewInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<View> getWithResponse(String viewName, Context context) {
        Response<ViewInner> inner = this.serviceClient().getWithResponse(viewName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ViewImpl((ViewInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public View get(String viewName) {
        ViewInner inner = this.serviceClient().get(viewName);
        if (inner != null) {
            return new ViewImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<View> createOrUpdateWithResponse(String viewName, ViewInner parameters, Context context) {
        Response<ViewInner> inner = this.serviceClient().createOrUpdateWithResponse(viewName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ViewImpl((ViewInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public View createOrUpdate(String viewName, ViewInner parameters) {
        ViewInner inner = this.serviceClient().createOrUpdate(viewName, parameters);
        if (inner != null) {
            return new ViewImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String viewName, Context context) {
        return this.serviceClient().deleteWithResponse(viewName, context);
    }

    @Override
    public void delete(String viewName) {
        this.serviceClient().delete(viewName);
    }

    @Override
    public Response<View> getByScopeWithResponse(String scope, String viewName, Context context) {
        Response<ViewInner> inner = this.serviceClient().getByScopeWithResponse(scope, viewName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ViewImpl((ViewInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public View getByScope(String scope, String viewName) {
        ViewInner inner = this.serviceClient().getByScope(scope, viewName);
        if (inner != null) {
            return new ViewImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByScopeWithResponse(String scope, String viewName, Context context) {
        return this.serviceClient().deleteByScopeWithResponse(scope, viewName, context);
    }

    @Override
    public void deleteByScope(String scope, String viewName) {
        this.serviceClient().deleteByScope(scope, viewName);
    }

    @Override
    public View getById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String viewName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "viewName");
        if (viewName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'views'.", id)));
        }
        return (View)this.getByScopeWithResponse(scope, viewName, Context.NONE).getValue();
    }

    @Override
    public Response<View> getByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String viewName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "viewName");
        if (viewName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'views'.", id)));
        }
        return this.getByScopeWithResponse(scope, viewName, context);
    }

    @Override
    public void deleteById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String viewName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "viewName");
        if (viewName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'views'.", id)));
        }
        this.deleteByScopeWithResponse(scope, viewName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String viewName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.CostManagement/views/{viewName}", "viewName");
        if (viewName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'views'.", id)));
        }
        return this.deleteByScopeWithResponse(scope, viewName, context);
    }

    private ViewsClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ViewImpl define(String name) {
        return new ViewImpl(name, this.manager());
    }
}

