/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.AlertCategory;
import com.azure.resourcemanager.costmanagement.models.AlertCriteria;
import com.azure.resourcemanager.costmanagement.models.AlertType;
import java.io.IOException;

public final class AlertPropertiesDefinition
implements JsonSerializable<AlertPropertiesDefinition> {
    private AlertType type;
    private AlertCategory category;
    private AlertCriteria criteria;

    public AlertType type() {
        return this.type;
    }

    public AlertPropertiesDefinition withType(AlertType type) {
        this.type = type;
        return this;
    }

    public AlertCategory category() {
        return this.category;
    }

    public AlertPropertiesDefinition withCategory(AlertCategory category) {
        this.category = category;
        return this;
    }

    public AlertCriteria criteria() {
        return this.criteria;
    }

    public AlertPropertiesDefinition withCriteria(AlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("category", this.category == null ? null : this.category.toString());
        jsonWriter.writeStringField("criteria", this.criteria == null ? null : this.criteria.toString());
        return jsonWriter.writeEndObject();
    }

    public static AlertPropertiesDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (AlertPropertiesDefinition)jsonReader.readObject(reader -> {
            AlertPropertiesDefinition deserializedAlertPropertiesDefinition = new AlertPropertiesDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedAlertPropertiesDefinition.type = AlertType.fromString(reader.getString());
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedAlertPropertiesDefinition.category = AlertCategory.fromString(reader.getString());
                    continue;
                }
                if ("criteria".equals(fieldName)) {
                    deserializedAlertPropertiesDefinition.criteria = AlertCriteria.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAlertPropertiesDefinition;
        });
    }
}

