/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.AllSavingsBenefitDetails;
import com.azure.resourcemanager.costmanagement.models.AllSavingsList;
import com.azure.resourcemanager.costmanagement.models.Grain;
import com.azure.resourcemanager.costmanagement.models.LookBackPeriod;
import com.azure.resourcemanager.costmanagement.models.RecommendationUsageDetails;
import com.azure.resourcemanager.costmanagement.models.Scope;
import com.azure.resourcemanager.costmanagement.models.SharedScopeBenefitRecommendationProperties;
import com.azure.resourcemanager.costmanagement.models.SingleScopeBenefitRecommendationProperties;
import com.azure.resourcemanager.costmanagement.models.Term;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

public class BenefitRecommendationProperties
implements JsonSerializable<BenefitRecommendationProperties> {
    private Scope scope = Scope.fromString("BenefitRecommendationProperties");
    private OffsetDateTime firstConsumptionDate;
    private OffsetDateTime lastConsumptionDate;
    private LookBackPeriod lookBackPeriod;
    private Integer totalHours;
    private RecommendationUsageDetails usage;
    private String armSkuName;
    private Term term;
    private Grain commitmentGranularity;
    private String currencyCode;
    private BigDecimal costWithoutBenefit;
    private AllSavingsBenefitDetails recommendationDetails;
    private AllSavingsList allRecommendationDetails;

    public Scope scope() {
        return this.scope;
    }

    public OffsetDateTime firstConsumptionDate() {
        return this.firstConsumptionDate;
    }

    BenefitRecommendationProperties withFirstConsumptionDate(OffsetDateTime firstConsumptionDate) {
        this.firstConsumptionDate = firstConsumptionDate;
        return this;
    }

    public OffsetDateTime lastConsumptionDate() {
        return this.lastConsumptionDate;
    }

    BenefitRecommendationProperties withLastConsumptionDate(OffsetDateTime lastConsumptionDate) {
        this.lastConsumptionDate = lastConsumptionDate;
        return this;
    }

    public LookBackPeriod lookBackPeriod() {
        return this.lookBackPeriod;
    }

    public BenefitRecommendationProperties withLookBackPeriod(LookBackPeriod lookBackPeriod) {
        this.lookBackPeriod = lookBackPeriod;
        return this;
    }

    public Integer totalHours() {
        return this.totalHours;
    }

    BenefitRecommendationProperties withTotalHours(Integer totalHours) {
        this.totalHours = totalHours;
        return this;
    }

    public RecommendationUsageDetails usage() {
        return this.usage;
    }

    public BenefitRecommendationProperties withUsage(RecommendationUsageDetails usage) {
        this.usage = usage;
        return this;
    }

    public String armSkuName() {
        return this.armSkuName;
    }

    BenefitRecommendationProperties withArmSkuName(String armSkuName) {
        this.armSkuName = armSkuName;
        return this;
    }

    public Term term() {
        return this.term;
    }

    public BenefitRecommendationProperties withTerm(Term term) {
        this.term = term;
        return this;
    }

    public Grain commitmentGranularity() {
        return this.commitmentGranularity;
    }

    public BenefitRecommendationProperties withCommitmentGranularity(Grain commitmentGranularity) {
        this.commitmentGranularity = commitmentGranularity;
        return this;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    BenefitRecommendationProperties withCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public BigDecimal costWithoutBenefit() {
        return this.costWithoutBenefit;
    }

    BenefitRecommendationProperties withCostWithoutBenefit(BigDecimal costWithoutBenefit) {
        this.costWithoutBenefit = costWithoutBenefit;
        return this;
    }

    public AllSavingsBenefitDetails recommendationDetails() {
        return this.recommendationDetails;
    }

    public BenefitRecommendationProperties withRecommendationDetails(AllSavingsBenefitDetails recommendationDetails) {
        this.recommendationDetails = recommendationDetails;
        return this;
    }

    public AllSavingsList allRecommendationDetails() {
        return this.allRecommendationDetails;
    }

    BenefitRecommendationProperties withAllRecommendationDetails(AllSavingsList allRecommendationDetails) {
        this.allRecommendationDetails = allRecommendationDetails;
        return this;
    }

    public void validate() {
        if (this.usage() != null) {
            this.usage().validate();
        }
        if (this.recommendationDetails() != null) {
            this.recommendationDetails().validate();
        }
        if (this.allRecommendationDetails() != null) {
            this.allRecommendationDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        jsonWriter.writeStringField("lookBackPeriod", this.lookBackPeriod == null ? null : this.lookBackPeriod.toString());
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        jsonWriter.writeStringField("term", this.term == null ? null : this.term.toString());
        jsonWriter.writeStringField("commitmentGranularity", this.commitmentGranularity == null ? null : this.commitmentGranularity.toString());
        jsonWriter.writeJsonField("recommendationDetails", (JsonSerializable)this.recommendationDetails);
        return jsonWriter.writeEndObject();
    }

    public static BenefitRecommendationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BenefitRecommendationProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                BenefitRecommendationProperties benefitRecommendationProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("scope".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Single".equals(discriminatorValue)) {
                    benefitRecommendationProperties = SingleScopeBenefitRecommendationProperties.fromJson(readerToUse.reset());
                    return benefitRecommendationProperties;
                }
                if ("Shared".equals(discriminatorValue)) {
                    benefitRecommendationProperties = SharedScopeBenefitRecommendationProperties.fromJson(readerToUse.reset());
                    return benefitRecommendationProperties;
                }
                benefitRecommendationProperties = BenefitRecommendationProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return benefitRecommendationProperties;
            }
        });
    }

    static BenefitRecommendationProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (BenefitRecommendationProperties)jsonReader.readObject(reader -> {
            BenefitRecommendationProperties deserializedBenefitRecommendationProperties = new BenefitRecommendationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.scope = Scope.fromString(reader.getString());
                    continue;
                }
                if ("firstConsumptionDate".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.firstConsumptionDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastConsumptionDate".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.lastConsumptionDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lookBackPeriod".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.lookBackPeriod = LookBackPeriod.fromString(reader.getString());
                    continue;
                }
                if ("totalHours".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.totalHours = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.usage = RecommendationUsageDetails.fromJson(reader);
                    continue;
                }
                if ("armSkuName".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.armSkuName = reader.getString();
                    continue;
                }
                if ("term".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.term = Term.fromString(reader.getString());
                    continue;
                }
                if ("commitmentGranularity".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.commitmentGranularity = Grain.fromString(reader.getString());
                    continue;
                }
                if ("currencyCode".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.currencyCode = reader.getString();
                    continue;
                }
                if ("costWithoutBenefit".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.costWithoutBenefit = (BigDecimal)reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                    continue;
                }
                if ("recommendationDetails".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.recommendationDetails = AllSavingsBenefitDetails.fromJson(reader);
                    continue;
                }
                if ("allRecommendationDetails".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.allRecommendationDetails = AllSavingsList.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBenefitRecommendationProperties;
        });
    }
}

