/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import java.io.IOException;
import java.time.OffsetDateTime;

public class BenefitUtilizationSummaryProperties
implements JsonSerializable<BenefitUtilizationSummaryProperties> {
    private String armSkuName;
    private String benefitId;
    private String benefitOrderId;
    private BenefitKind benefitType;
    private OffsetDateTime usageDate;

    public String armSkuName() {
        return this.armSkuName;
    }

    BenefitUtilizationSummaryProperties withArmSkuName(String armSkuName) {
        this.armSkuName = armSkuName;
        return this;
    }

    public String benefitId() {
        return this.benefitId;
    }

    BenefitUtilizationSummaryProperties withBenefitId(String benefitId) {
        this.benefitId = benefitId;
        return this;
    }

    public String benefitOrderId() {
        return this.benefitOrderId;
    }

    BenefitUtilizationSummaryProperties withBenefitOrderId(String benefitOrderId) {
        this.benefitOrderId = benefitOrderId;
        return this;
    }

    public BenefitKind benefitType() {
        return this.benefitType;
    }

    public BenefitUtilizationSummaryProperties withBenefitType(BenefitKind benefitType) {
        this.benefitType = benefitType;
        return this;
    }

    public OffsetDateTime usageDate() {
        return this.usageDate;
    }

    BenefitUtilizationSummaryProperties withUsageDate(OffsetDateTime usageDate) {
        this.usageDate = usageDate;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("benefitType", this.benefitType == null ? null : this.benefitType.toString());
        return jsonWriter.writeEndObject();
    }

    public static BenefitUtilizationSummaryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BenefitUtilizationSummaryProperties)jsonReader.readObject(reader -> {
            BenefitUtilizationSummaryProperties deserializedBenefitUtilizationSummaryProperties = new BenefitUtilizationSummaryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("armSkuName".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.armSkuName = reader.getString();
                    continue;
                }
                if ("benefitId".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.benefitId = reader.getString();
                    continue;
                }
                if ("benefitOrderId".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.benefitOrderId = reader.getString();
                    continue;
                }
                if ("benefitType".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.benefitType = BenefitKind.fromString(reader.getString());
                    continue;
                }
                if ("usageDate".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.usageDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBenefitUtilizationSummaryProperties;
        });
    }
}

