/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class CostManagementResource
extends Resource {
    private String sku;
    private String etag;
    private String type;
    private String name;
    private String id;

    public String sku() {
        return this.sku;
    }

    CostManagementResource withSku(String sku) {
        this.sku = sku;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    CostManagementResource withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public CostManagementResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CostManagementResource withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CostManagementResource fromJson(JsonReader jsonReader) throws IOException {
        return (CostManagementResource)((Object)jsonReader.readObject(reader -> {
            CostManagementResource deserializedCostManagementResource = new CostManagementResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCostManagementResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCostManagementResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCostManagementResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCostManagementResource.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCostManagementResource.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedCostManagementResource.sku = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedCostManagementResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCostManagementResource;
        }));
    }
}

