/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportExecutionListResultInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportInner;
import com.azure.resourcemanager.costmanagement.models.ExportDefinition;
import com.azure.resourcemanager.costmanagement.models.ExportDeliveryInfo;
import com.azure.resourcemanager.costmanagement.models.ExportExecutionListResult;
import com.azure.resourcemanager.costmanagement.models.ExportSchedule;
import com.azure.resourcemanager.costmanagement.models.FormatType;
import java.time.OffsetDateTime;

public interface Export {
    public String id();

    public String name();

    public String type();

    public String etag();

    public ExportSchedule schedule();

    public FormatType format();

    public ExportDeliveryInfo deliveryInfo();

    public ExportDefinition definition();

    public ExportExecutionListResult runHistory();

    public Boolean partitionData();

    public OffsetDateTime nextRunTimeEstimate();

    public ExportInner innerModel();

    public Update update();

    public Export refresh();

    public Export refresh(Context var1);

    public Response<Void> executeWithResponse(Context var1);

    public void execute();

    public static interface UpdateStages {

        public static interface WithPartitionData {
            public Update withPartitionData(Boolean var1);
        }

        public static interface WithRunHistory {
            public Update withRunHistory(ExportExecutionListResultInner var1);
        }

        public static interface WithDefinition {
            public Update withDefinition(ExportDefinition var1);
        }

        public static interface WithDeliveryInfo {
            public Update withDeliveryInfo(ExportDeliveryInfo var1);
        }

        public static interface WithFormat {
            public Update withFormat(FormatType var1);
        }

        public static interface WithSchedule {
            public Update withSchedule(ExportSchedule var1);
        }

        public static interface WithEtag {
            public Update withEtag(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithEtag,
    UpdateStages.WithSchedule,
    UpdateStages.WithFormat,
    UpdateStages.WithDeliveryInfo,
    UpdateStages.WithDefinition,
    UpdateStages.WithRunHistory,
    UpdateStages.WithPartitionData {
        public Export apply();

        public Export apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithPartitionData {
            public WithCreate withPartitionData(Boolean var1);
        }

        public static interface WithRunHistory {
            public WithCreate withRunHistory(ExportExecutionListResultInner var1);
        }

        public static interface WithDefinition {
            public WithCreate withDefinition(ExportDefinition var1);
        }

        public static interface WithDeliveryInfo {
            public WithCreate withDeliveryInfo(ExportDeliveryInfo var1);
        }

        public static interface WithFormat {
            public WithCreate withFormat(FormatType var1);
        }

        public static interface WithSchedule {
            public WithCreate withSchedule(ExportSchedule var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithCreate
        extends WithEtag,
        WithSchedule,
        WithFormat,
        WithDeliveryInfo,
        WithDefinition,
        WithRunHistory,
        WithPartitionData {
            public Export create();

            public Export create(Context var1);
        }

        public static interface WithScope {
            public WithCreate withExistingScope(String var1);
        }

        public static interface Blank
        extends WithScope {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithScope,
    DefinitionStages.WithCreate {
    }
}

