/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ExportDatasetConfiguration;
import com.azure.resourcemanager.costmanagement.models.GranularityType;
import java.io.IOException;

public final class ExportDataset
implements JsonSerializable<ExportDataset> {
    private GranularityType granularity;
    private ExportDatasetConfiguration configuration;

    public GranularityType granularity() {
        return this.granularity;
    }

    public ExportDataset withGranularity(GranularityType granularity) {
        this.granularity = granularity;
        return this;
    }

    public ExportDatasetConfiguration configuration() {
        return this.configuration;
    }

    public ExportDataset withConfiguration(ExportDatasetConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        return jsonWriter.writeEndObject();
    }

    public static ExportDataset fromJson(JsonReader jsonReader) throws IOException {
        return (ExportDataset)jsonReader.readObject(reader -> {
            ExportDataset deserializedExportDataset = new ExportDataset();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("granularity".equals(fieldName)) {
                    deserializedExportDataset.granularity = GranularityType.fromString(reader.getString());
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedExportDataset.configuration = ExportDatasetConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportDataset;
        });
    }
}

