/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ExportDataset;
import com.azure.resourcemanager.costmanagement.models.ExportTimePeriod;
import com.azure.resourcemanager.costmanagement.models.ExportType;
import com.azure.resourcemanager.costmanagement.models.TimeframeType;
import java.io.IOException;

public final class ExportDefinition
implements JsonSerializable<ExportDefinition> {
    private ExportType type;
    private TimeframeType timeframe;
    private ExportTimePeriod timePeriod;
    private ExportDataset dataSet;
    private static final ClientLogger LOGGER = new ClientLogger(ExportDefinition.class);

    public ExportType type() {
        return this.type;
    }

    public ExportDefinition withType(ExportType type) {
        this.type = type;
        return this;
    }

    public TimeframeType timeframe() {
        return this.timeframe;
    }

    public ExportDefinition withTimeframe(TimeframeType timeframe) {
        this.timeframe = timeframe;
        return this;
    }

    public ExportTimePeriod timePeriod() {
        return this.timePeriod;
    }

    public ExportDefinition withTimePeriod(ExportTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        return this;
    }

    public ExportDataset dataSet() {
        return this.dataSet;
    }

    public ExportDefinition withDataSet(ExportDataset dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ExportDefinition"));
        }
        if (this.timeframe() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeframe in model ExportDefinition"));
        }
        if (this.timePeriod() != null) {
            this.timePeriod().validate();
        }
        if (this.dataSet() != null) {
            this.dataSet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("timeframe", this.timeframe == null ? null : this.timeframe.toString());
        jsonWriter.writeJsonField("timePeriod", (JsonSerializable)this.timePeriod);
        jsonWriter.writeJsonField("dataSet", (JsonSerializable)this.dataSet);
        return jsonWriter.writeEndObject();
    }

    public static ExportDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ExportDefinition)jsonReader.readObject(reader -> {
            ExportDefinition deserializedExportDefinition = new ExportDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExportDefinition.type = ExportType.fromString(reader.getString());
                    continue;
                }
                if ("timeframe".equals(fieldName)) {
                    deserializedExportDefinition.timeframe = TimeframeType.fromString(reader.getString());
                    continue;
                }
                if ("timePeriod".equals(fieldName)) {
                    deserializedExportDefinition.timePeriod = ExportTimePeriod.fromJson(reader);
                    continue;
                }
                if ("dataSet".equals(fieldName)) {
                    deserializedExportDefinition.dataSet = ExportDataset.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportDefinition;
        });
    }
}

