/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ExportDeliveryDestination
implements JsonSerializable<ExportDeliveryDestination> {
    private String resourceId;
    private String container;
    private String rootFolderPath;
    private String sasToken;
    private String storageAccount;
    private static final ClientLogger LOGGER = new ClientLogger(ExportDeliveryDestination.class);

    public String resourceId() {
        return this.resourceId;
    }

    public ExportDeliveryDestination withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String container() {
        return this.container;
    }

    public ExportDeliveryDestination withContainer(String container) {
        this.container = container;
        return this;
    }

    public String rootFolderPath() {
        return this.rootFolderPath;
    }

    public ExportDeliveryDestination withRootFolderPath(String rootFolderPath) {
        this.rootFolderPath = rootFolderPath;
        return this;
    }

    public String sasToken() {
        return this.sasToken;
    }

    public ExportDeliveryDestination withSasToken(String sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    public String storageAccount() {
        return this.storageAccount;
    }

    public ExportDeliveryDestination withStorageAccount(String storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    public void validate() {
        if (this.container() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property container in model ExportDeliveryDestination"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("container", this.container);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("rootFolderPath", this.rootFolderPath);
        jsonWriter.writeStringField("sasToken", this.sasToken);
        jsonWriter.writeStringField("storageAccount", this.storageAccount);
        return jsonWriter.writeEndObject();
    }

    public static ExportDeliveryDestination fromJson(JsonReader jsonReader) throws IOException {
        return (ExportDeliveryDestination)jsonReader.readObject(reader -> {
            ExportDeliveryDestination deserializedExportDeliveryDestination = new ExportDeliveryDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("container".equals(fieldName)) {
                    deserializedExportDeliveryDestination.container = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedExportDeliveryDestination.resourceId = reader.getString();
                    continue;
                }
                if ("rootFolderPath".equals(fieldName)) {
                    deserializedExportDeliveryDestination.rootFolderPath = reader.getString();
                    continue;
                }
                if ("sasToken".equals(fieldName)) {
                    deserializedExportDeliveryDestination.sasToken = reader.getString();
                    continue;
                }
                if ("storageAccount".equals(fieldName)) {
                    deserializedExportDeliveryDestination.storageAccount = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportDeliveryDestination;
        });
    }
}

