/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ExportDeliveryDestination;
import java.io.IOException;

public final class ExportDeliveryInfo
implements JsonSerializable<ExportDeliveryInfo> {
    private ExportDeliveryDestination destination;
    private static final ClientLogger LOGGER = new ClientLogger(ExportDeliveryInfo.class);

    public ExportDeliveryDestination destination() {
        return this.destination;
    }

    public ExportDeliveryInfo withDestination(ExportDeliveryDestination destination) {
        this.destination = destination;
        return this;
    }

    public void validate() {
        if (this.destination() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destination in model ExportDeliveryInfo"));
        }
        this.destination().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination);
        return jsonWriter.writeEndObject();
    }

    public static ExportDeliveryInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ExportDeliveryInfo)jsonReader.readObject(reader -> {
            ExportDeliveryInfo deserializedExportDeliveryInfo = new ExportDeliveryInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("destination".equals(fieldName)) {
                    deserializedExportDeliveryInfo.destination = ExportDeliveryDestination.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportDeliveryInfo;
        });
    }
}

