/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ExportRecurrencePeriod
implements JsonSerializable<ExportRecurrencePeriod> {
    private OffsetDateTime from;
    private OffsetDateTime to;
    private static final ClientLogger LOGGER = new ClientLogger(ExportRecurrencePeriod.class);

    public OffsetDateTime from() {
        return this.from;
    }

    public ExportRecurrencePeriod withFrom(OffsetDateTime from) {
        this.from = from;
        return this;
    }

    public OffsetDateTime to() {
        return this.to;
    }

    public ExportRecurrencePeriod withTo(OffsetDateTime to) {
        this.to = to;
        return this;
    }

    public void validate() {
        if (this.from() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property from in model ExportRecurrencePeriod"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from", this.from == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.from));
        jsonWriter.writeStringField("to", this.to == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.to));
        return jsonWriter.writeEndObject();
    }

    public static ExportRecurrencePeriod fromJson(JsonReader jsonReader) throws IOException {
        return (ExportRecurrencePeriod)jsonReader.readObject(reader -> {
            ExportRecurrencePeriod deserializedExportRecurrencePeriod = new ExportRecurrencePeriod();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("from".equals(fieldName)) {
                    deserializedExportRecurrencePeriod.from = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("to".equals(fieldName)) {
                    deserializedExportRecurrencePeriod.to = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportRecurrencePeriod;
        });
    }
}

