/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ExportRecurrencePeriod;
import com.azure.resourcemanager.costmanagement.models.RecurrenceType;
import com.azure.resourcemanager.costmanagement.models.StatusType;
import java.io.IOException;

public final class ExportSchedule
implements JsonSerializable<ExportSchedule> {
    private StatusType status;
    private RecurrenceType recurrence;
    private ExportRecurrencePeriod recurrencePeriod;

    public StatusType status() {
        return this.status;
    }

    public ExportSchedule withStatus(StatusType status) {
        this.status = status;
        return this;
    }

    public RecurrenceType recurrence() {
        return this.recurrence;
    }

    public ExportSchedule withRecurrence(RecurrenceType recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public ExportRecurrencePeriod recurrencePeriod() {
        return this.recurrencePeriod;
    }

    public ExportSchedule withRecurrencePeriod(ExportRecurrencePeriod recurrencePeriod) {
        this.recurrencePeriod = recurrencePeriod;
        return this;
    }

    public void validate() {
        if (this.recurrencePeriod() != null) {
            this.recurrencePeriod().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("recurrence", this.recurrence == null ? null : this.recurrence.toString());
        jsonWriter.writeJsonField("recurrencePeriod", (JsonSerializable)this.recurrencePeriod);
        return jsonWriter.writeEndObject();
    }

    public static ExportSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (ExportSchedule)jsonReader.readObject(reader -> {
            ExportSchedule deserializedExportSchedule = new ExportSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedExportSchedule.status = StatusType.fromString(reader.getString());
                    continue;
                }
                if ("recurrence".equals(fieldName)) {
                    deserializedExportSchedule.recurrence = RecurrenceType.fromString(reader.getString());
                    continue;
                }
                if ("recurrencePeriod".equals(fieldName)) {
                    deserializedExportSchedule.recurrencePeriod = ExportRecurrencePeriod.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportSchedule;
        });
    }
}

