/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.FunctionName;
import com.azure.resourcemanager.costmanagement.models.FunctionType;
import java.io.IOException;

public final class ForecastAggregation
implements JsonSerializable<ForecastAggregation> {
    private FunctionName name;
    private FunctionType function;
    private static final ClientLogger LOGGER = new ClientLogger(ForecastAggregation.class);

    public FunctionName name() {
        return this.name;
    }

    public ForecastAggregation withName(FunctionName name) {
        this.name = name;
        return this;
    }

    public FunctionType function() {
        return this.function;
    }

    public ForecastAggregation withFunction(FunctionType function) {
        this.function = function;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ForecastAggregation"));
        }
        if (this.function() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property function in model ForecastAggregation"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("function", this.function == null ? null : this.function.toString());
        return jsonWriter.writeEndObject();
    }

    public static ForecastAggregation fromJson(JsonReader jsonReader) throws IOException {
        return (ForecastAggregation)jsonReader.readObject(reader -> {
            ForecastAggregation deserializedForecastAggregation = new ForecastAggregation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedForecastAggregation.name = FunctionName.fromString(reader.getString());
                    continue;
                }
                if ("function".equals(fieldName)) {
                    deserializedForecastAggregation.function = FunctionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForecastAggregation;
        });
    }
}

