/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ForecastOperatorType;
import java.io.IOException;
import java.util.List;

public final class ForecastComparisonExpression
implements JsonSerializable<ForecastComparisonExpression> {
    private String name;
    private ForecastOperatorType operator;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(ForecastComparisonExpression.class);

    public String name() {
        return this.name;
    }

    public ForecastComparisonExpression withName(String name) {
        this.name = name;
        return this;
    }

    public ForecastOperatorType operator() {
        return this.operator;
    }

    public ForecastComparisonExpression withOperator(ForecastOperatorType operator) {
        this.operator = operator;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public ForecastComparisonExpression withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ForecastComparisonExpression"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model ForecastComparisonExpression"));
        }
        if (this.values() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property values in model ForecastComparisonExpression"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ForecastComparisonExpression fromJson(JsonReader jsonReader) throws IOException {
        return (ForecastComparisonExpression)jsonReader.readObject(reader -> {
            ForecastComparisonExpression deserializedForecastComparisonExpression = new ForecastComparisonExpression();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedForecastComparisonExpression.name = reader.getString();
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedForecastComparisonExpression.operator = ForecastOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedForecastComparisonExpression.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForecastComparisonExpression;
        });
    }
}

