/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ForecastAggregation;
import com.azure.resourcemanager.costmanagement.models.ForecastDatasetConfiguration;
import com.azure.resourcemanager.costmanagement.models.ForecastFilter;
import com.azure.resourcemanager.costmanagement.models.GranularityType;
import java.io.IOException;
import java.util.Map;

public final class ForecastDataset
implements JsonSerializable<ForecastDataset> {
    private GranularityType granularity;
    private ForecastDatasetConfiguration configuration;
    private Map<String, ForecastAggregation> aggregation;
    private ForecastFilter filter;
    private static final ClientLogger LOGGER = new ClientLogger(ForecastDataset.class);

    public GranularityType granularity() {
        return this.granularity;
    }

    public ForecastDataset withGranularity(GranularityType granularity) {
        this.granularity = granularity;
        return this;
    }

    public ForecastDatasetConfiguration configuration() {
        return this.configuration;
    }

    public ForecastDataset withConfiguration(ForecastDatasetConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Map<String, ForecastAggregation> aggregation() {
        return this.aggregation;
    }

    public ForecastDataset withAggregation(Map<String, ForecastAggregation> aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public ForecastFilter filter() {
        return this.filter;
    }

    public ForecastDataset withFilter(ForecastFilter filter) {
        this.filter = filter;
        return this;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.aggregation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property aggregation in model ForecastDataset"));
        }
        this.aggregation().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
        if (this.filter() != null) {
            this.filter().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("aggregation", this.aggregation, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeJsonField("filter", (JsonSerializable)this.filter);
        return jsonWriter.writeEndObject();
    }

    public static ForecastDataset fromJson(JsonReader jsonReader) throws IOException {
        return (ForecastDataset)jsonReader.readObject(reader -> {
            ForecastDataset deserializedForecastDataset = new ForecastDataset();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("aggregation".equals(fieldName)) {
                    Map aggregation;
                    deserializedForecastDataset.aggregation = aggregation = reader.readMap(reader1 -> ForecastAggregation.fromJson(reader1));
                    continue;
                }
                if ("granularity".equals(fieldName)) {
                    deserializedForecastDataset.granularity = GranularityType.fromString(reader.getString());
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedForecastDataset.configuration = ForecastDatasetConfiguration.fromJson(reader);
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedForecastDataset.filter = ForecastFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForecastDataset;
        });
    }
}

