/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ForecastDataset;
import com.azure.resourcemanager.costmanagement.models.ForecastTimePeriod;
import com.azure.resourcemanager.costmanagement.models.ForecastTimeframe;
import com.azure.resourcemanager.costmanagement.models.ForecastType;
import java.io.IOException;

public final class ForecastDefinition
implements JsonSerializable<ForecastDefinition> {
    private ForecastType type;
    private ForecastTimeframe timeframe;
    private ForecastTimePeriod timePeriod;
    private ForecastDataset dataset;
    private Boolean includeActualCost;
    private Boolean includeFreshPartialCost;
    private static final ClientLogger LOGGER = new ClientLogger(ForecastDefinition.class);

    public ForecastType type() {
        return this.type;
    }

    public ForecastDefinition withType(ForecastType type) {
        this.type = type;
        return this;
    }

    public ForecastTimeframe timeframe() {
        return this.timeframe;
    }

    public ForecastDefinition withTimeframe(ForecastTimeframe timeframe) {
        this.timeframe = timeframe;
        return this;
    }

    public ForecastTimePeriod timePeriod() {
        return this.timePeriod;
    }

    public ForecastDefinition withTimePeriod(ForecastTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        return this;
    }

    public ForecastDataset dataset() {
        return this.dataset;
    }

    public ForecastDefinition withDataset(ForecastDataset dataset) {
        this.dataset = dataset;
        return this;
    }

    public Boolean includeActualCost() {
        return this.includeActualCost;
    }

    public ForecastDefinition withIncludeActualCost(Boolean includeActualCost) {
        this.includeActualCost = includeActualCost;
        return this;
    }

    public Boolean includeFreshPartialCost() {
        return this.includeFreshPartialCost;
    }

    public ForecastDefinition withIncludeFreshPartialCost(Boolean includeFreshPartialCost) {
        this.includeFreshPartialCost = includeFreshPartialCost;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ForecastDefinition"));
        }
        if (this.timeframe() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeframe in model ForecastDefinition"));
        }
        if (this.timePeriod() != null) {
            this.timePeriod().validate();
        }
        if (this.dataset() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataset in model ForecastDefinition"));
        }
        this.dataset().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("timeframe", this.timeframe == null ? null : this.timeframe.toString());
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
        jsonWriter.writeJsonField("timePeriod", (JsonSerializable)this.timePeriod);
        jsonWriter.writeBooleanField("includeActualCost", this.includeActualCost);
        jsonWriter.writeBooleanField("includeFreshPartialCost", this.includeFreshPartialCost);
        return jsonWriter.writeEndObject();
    }

    public static ForecastDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ForecastDefinition)jsonReader.readObject(reader -> {
            ForecastDefinition deserializedForecastDefinition = new ForecastDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedForecastDefinition.type = ForecastType.fromString(reader.getString());
                    continue;
                }
                if ("timeframe".equals(fieldName)) {
                    deserializedForecastDefinition.timeframe = ForecastTimeframe.fromString(reader.getString());
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedForecastDefinition.dataset = ForecastDataset.fromJson(reader);
                    continue;
                }
                if ("timePeriod".equals(fieldName)) {
                    deserializedForecastDefinition.timePeriod = ForecastTimePeriod.fromJson(reader);
                    continue;
                }
                if ("includeActualCost".equals(fieldName)) {
                    deserializedForecastDefinition.includeActualCost = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("includeFreshPartialCost".equals(fieldName)) {
                    deserializedForecastDefinition.includeFreshPartialCost = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForecastDefinition;
        });
    }
}

