/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ForecastComparisonExpression;
import java.io.IOException;
import java.util.List;

public final class ForecastFilter
implements JsonSerializable<ForecastFilter> {
    private List<ForecastFilter> and;
    private List<ForecastFilter> or;
    private ForecastComparisonExpression dimensions;
    private ForecastComparisonExpression tags;

    public List<ForecastFilter> and() {
        return this.and;
    }

    public ForecastFilter withAnd(List<ForecastFilter> and) {
        this.and = and;
        return this;
    }

    public List<ForecastFilter> or() {
        return this.or;
    }

    public ForecastFilter withOr(List<ForecastFilter> or) {
        this.or = or;
        return this;
    }

    public ForecastComparisonExpression dimensions() {
        return this.dimensions;
    }

    public ForecastFilter withDimensions(ForecastComparisonExpression dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public ForecastComparisonExpression tags() {
        return this.tags;
    }

    public ForecastFilter withTags(ForecastComparisonExpression tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.and() != null) {
            this.and().forEach(e -> e.validate());
        }
        if (this.or() != null) {
            this.or().forEach(e -> e.validate());
        }
        if (this.dimensions() != null) {
            this.dimensions().validate();
        }
        if (this.tags() != null) {
            this.tags().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("and", this.and, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("or", this.or, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dimensions", (JsonSerializable)this.dimensions);
        jsonWriter.writeJsonField("tags", (JsonSerializable)this.tags);
        return jsonWriter.writeEndObject();
    }

    public static ForecastFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ForecastFilter)jsonReader.readObject(reader -> {
            ForecastFilter deserializedForecastFilter = new ForecastFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("and".equals(fieldName)) {
                    List and;
                    deserializedForecastFilter.and = and = reader.readArray(reader1 -> ForecastFilter.fromJson(reader1));
                    continue;
                }
                if ("or".equals(fieldName)) {
                    List or;
                    deserializedForecastFilter.or = or = reader.readArray(reader1 -> ForecastFilter.fromJson(reader1));
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    deserializedForecastFilter.dimensions = ForecastComparisonExpression.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    deserializedForecastFilter.tags = ForecastComparisonExpression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForecastFilter;
        });
    }
}

