/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.CostDetailsMetricType;
import com.azure.resourcemanager.costmanagement.models.CostDetailsTimePeriod;
import java.io.IOException;

public final class GenerateCostDetailsReportRequestDefinition
implements JsonSerializable<GenerateCostDetailsReportRequestDefinition> {
    private CostDetailsMetricType metric;
    private CostDetailsTimePeriod timePeriod;
    private String billingPeriod;
    private String invoiceId;

    public CostDetailsMetricType metric() {
        return this.metric;
    }

    public GenerateCostDetailsReportRequestDefinition withMetric(CostDetailsMetricType metric) {
        this.metric = metric;
        return this;
    }

    public CostDetailsTimePeriod timePeriod() {
        return this.timePeriod;
    }

    public GenerateCostDetailsReportRequestDefinition withTimePeriod(CostDetailsTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        return this;
    }

    public String billingPeriod() {
        return this.billingPeriod;
    }

    public GenerateCostDetailsReportRequestDefinition withBillingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    public String invoiceId() {
        return this.invoiceId;
    }

    public GenerateCostDetailsReportRequestDefinition withInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    public void validate() {
        if (this.timePeriod() != null) {
            this.timePeriod().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metric", this.metric == null ? null : this.metric.toString());
        jsonWriter.writeJsonField("timePeriod", (JsonSerializable)this.timePeriod);
        jsonWriter.writeStringField("billingPeriod", this.billingPeriod);
        jsonWriter.writeStringField("invoiceId", this.invoiceId);
        return jsonWriter.writeEndObject();
    }

    public static GenerateCostDetailsReportRequestDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (GenerateCostDetailsReportRequestDefinition)jsonReader.readObject(reader -> {
            GenerateCostDetailsReportRequestDefinition deserializedGenerateCostDetailsReportRequestDefinition = new GenerateCostDetailsReportRequestDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metric".equals(fieldName)) {
                    deserializedGenerateCostDetailsReportRequestDefinition.metric = CostDetailsMetricType.fromString(reader.getString());
                    continue;
                }
                if ("timePeriod".equals(fieldName)) {
                    deserializedGenerateCostDetailsReportRequestDefinition.timePeriod = CostDetailsTimePeriod.fromJson(reader);
                    continue;
                }
                if ("billingPeriod".equals(fieldName)) {
                    deserializedGenerateCostDetailsReportRequestDefinition.billingPeriod = reader.getString();
                    continue;
                }
                if ("invoiceId".equals(fieldName)) {
                    deserializedGenerateCostDetailsReportRequestDefinition.invoiceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGenerateCostDetailsReportRequestDefinition;
        });
    }
}

