/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportMetricType;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportTimePeriod;
import java.io.IOException;

public final class GenerateDetailedCostReportDefinition
implements JsonSerializable<GenerateDetailedCostReportDefinition> {
    private GenerateDetailedCostReportMetricType metric;
    private GenerateDetailedCostReportTimePeriod timePeriod;
    private String billingPeriod;
    private String invoiceId;
    private String customerId;

    public GenerateDetailedCostReportMetricType metric() {
        return this.metric;
    }

    public GenerateDetailedCostReportDefinition withMetric(GenerateDetailedCostReportMetricType metric) {
        this.metric = metric;
        return this;
    }

    public GenerateDetailedCostReportTimePeriod timePeriod() {
        return this.timePeriod;
    }

    public GenerateDetailedCostReportDefinition withTimePeriod(GenerateDetailedCostReportTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        return this;
    }

    public String billingPeriod() {
        return this.billingPeriod;
    }

    public GenerateDetailedCostReportDefinition withBillingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    public String invoiceId() {
        return this.invoiceId;
    }

    public GenerateDetailedCostReportDefinition withInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    public String customerId() {
        return this.customerId;
    }

    public GenerateDetailedCostReportDefinition withCustomerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public void validate() {
        if (this.timePeriod() != null) {
            this.timePeriod().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metric", this.metric == null ? null : this.metric.toString());
        jsonWriter.writeJsonField("timePeriod", (JsonSerializable)this.timePeriod);
        jsonWriter.writeStringField("billingPeriod", this.billingPeriod);
        jsonWriter.writeStringField("invoiceId", this.invoiceId);
        jsonWriter.writeStringField("customerId", this.customerId);
        return jsonWriter.writeEndObject();
    }

    public static GenerateDetailedCostReportDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (GenerateDetailedCostReportDefinition)jsonReader.readObject(reader -> {
            GenerateDetailedCostReportDefinition deserializedGenerateDetailedCostReportDefinition = new GenerateDetailedCostReportDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metric".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.metric = GenerateDetailedCostReportMetricType.fromString(reader.getString());
                    continue;
                }
                if ("timePeriod".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.timePeriod = GenerateDetailedCostReportTimePeriod.fromJson(reader);
                    continue;
                }
                if ("billingPeriod".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.billingPeriod = reader.getString();
                    continue;
                }
                if ("invoiceId".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.invoiceId = reader.getString();
                    continue;
                }
                if ("customerId".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.customerId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGenerateDetailedCostReportDefinition;
        });
    }
}

