/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitUtilizationSummaryInner;
import com.azure.resourcemanager.costmanagement.fluent.models.IncludedQuantityUtilizationSummaryProperties;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

public final class IncludedQuantityUtilizationSummary
extends BenefitUtilizationSummaryInner {
    private BenefitKind kind = BenefitKind.INCLUDED_QUANTITY;
    private IncludedQuantityUtilizationSummaryProperties innerProperties;
    private String type;
    private String name;
    private String id;

    @Override
    public BenefitKind kind() {
        return this.kind;
    }

    private IncludedQuantityUtilizationSummaryProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public BigDecimal utilizationPercentage() {
        return this.innerProperties() == null ? null : this.innerProperties().utilizationPercentage();
    }

    public String armSkuName() {
        return this.innerProperties() == null ? null : this.innerProperties().armSkuName();
    }

    public String benefitId() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitId();
    }

    public String benefitOrderId() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitOrderId();
    }

    public BenefitKind benefitType() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitType();
    }

    public IncludedQuantityUtilizationSummary withBenefitType(BenefitKind benefitType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IncludedQuantityUtilizationSummaryProperties();
        }
        this.innerProperties().withBenefitType(benefitType);
        return this;
    }

    public OffsetDateTime usageDate() {
        return this.innerProperties() == null ? null : this.innerProperties().usageDate();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static IncludedQuantityUtilizationSummary fromJson(JsonReader jsonReader) throws IOException {
        return (IncludedQuantityUtilizationSummary)((Object)jsonReader.readObject(reader -> {
            IncludedQuantityUtilizationSummary deserializedIncludedQuantityUtilizationSummary = new IncludedQuantityUtilizationSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummary.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummary.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummary.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummary.kind = BenefitKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummary.innerProperties = IncludedQuantityUtilizationSummaryProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIncludedQuantityUtilizationSummary;
        }));
    }
}

