/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.KpiType;
import java.io.IOException;

public final class KpiProperties
implements JsonSerializable<KpiProperties> {
    private KpiType type;
    private String id;
    private Boolean enabled;

    public KpiType type() {
        return this.type;
    }

    public KpiProperties withType(KpiType type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public KpiProperties withId(String id) {
        this.id = id;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public KpiProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    public static KpiProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KpiProperties)jsonReader.readObject(reader -> {
            KpiProperties deserializedKpiProperties = new KpiProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedKpiProperties.type = KpiType.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedKpiProperties.id = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedKpiProperties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKpiProperties;
        });
    }
}

