/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class NotificationProperties
implements JsonSerializable<NotificationProperties> {
    private List<String> to;
    private String language;
    private String message;
    private String regionalFormat;
    private String subject;
    private static final ClientLogger LOGGER = new ClientLogger(NotificationProperties.class);

    public List<String> to() {
        return this.to;
    }

    public NotificationProperties withTo(List<String> to) {
        this.to = to;
        return this;
    }

    public String language() {
        return this.language;
    }

    public NotificationProperties withLanguage(String language) {
        this.language = language;
        return this;
    }

    public String message() {
        return this.message;
    }

    public NotificationProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    public String regionalFormat() {
        return this.regionalFormat;
    }

    public NotificationProperties withRegionalFormat(String regionalFormat) {
        this.regionalFormat = regionalFormat;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public NotificationProperties withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public void validate() {
        if (this.to() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property to in model NotificationProperties"));
        }
        if (this.subject() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subject in model NotificationProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("to", this.to, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("regionalFormat", this.regionalFormat);
        return jsonWriter.writeEndObject();
    }

    public static NotificationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NotificationProperties)jsonReader.readObject(reader -> {
            NotificationProperties deserializedNotificationProperties = new NotificationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("to".equals(fieldName)) {
                    List to;
                    deserializedNotificationProperties.to = to = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedNotificationProperties.subject = reader.getString();
                    continue;
                }
                if ("language".equals(fieldName)) {
                    deserializedNotificationProperties.language = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedNotificationProperties.message = reader.getString();
                    continue;
                }
                if ("regionalFormat".equals(fieldName)) {
                    deserializedNotificationProperties.regionalFormat = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNotificationProperties;
        });
    }
}

