/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ActionType;
import com.azure.resourcemanager.costmanagement.models.OperationDisplay;
import com.azure.resourcemanager.costmanagement.models.Origin;
import java.io.IOException;

public class Operation
implements JsonSerializable<Operation> {
    private String name;
    private Boolean isDataAction;
    private OperationDisplay display;
    private Origin origin;
    private ActionType actionType;

    public String name() {
        return this.name;
    }

    Operation withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    Operation withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public Operation withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public Origin origin() {
        return this.origin;
    }

    Operation withOrigin(Origin origin) {
        this.origin = origin;
        return this;
    }

    public ActionType actionType() {
        return this.actionType;
    }

    Operation withActionType(ActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        return jsonWriter.writeEndObject();
    }

    public static Operation fromJson(JsonReader jsonReader) throws IOException {
        return (Operation)jsonReader.readObject(reader -> {
            Operation deserializedOperation = new Operation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperation.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperation.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperation.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperation.origin = Origin.fromString(reader.getString());
                    continue;
                }
                if ("actionType".equals(fieldName)) {
                    deserializedOperation.actionType = ActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperation;
        });
    }
}

