/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.FunctionType;
import java.io.IOException;

public final class QueryAggregation
implements JsonSerializable<QueryAggregation> {
    private String name;
    private FunctionType function;
    private static final ClientLogger LOGGER = new ClientLogger(QueryAggregation.class);

    public String name() {
        return this.name;
    }

    public QueryAggregation withName(String name) {
        this.name = name;
        return this;
    }

    public FunctionType function() {
        return this.function;
    }

    public QueryAggregation withFunction(FunctionType function) {
        this.function = function;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model QueryAggregation"));
        }
        if (this.function() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property function in model QueryAggregation"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("function", this.function == null ? null : this.function.toString());
        return jsonWriter.writeEndObject();
    }

    public static QueryAggregation fromJson(JsonReader jsonReader) throws IOException {
        return (QueryAggregation)jsonReader.readObject(reader -> {
            QueryAggregation deserializedQueryAggregation = new QueryAggregation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedQueryAggregation.name = reader.getString();
                    continue;
                }
                if ("function".equals(fieldName)) {
                    deserializedQueryAggregation.function = FunctionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryAggregation;
        });
    }
}

