/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.QueryOperatorType;
import java.io.IOException;
import java.util.List;

public final class QueryComparisonExpression
implements JsonSerializable<QueryComparisonExpression> {
    private String name;
    private QueryOperatorType operator;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(QueryComparisonExpression.class);

    public String name() {
        return this.name;
    }

    public QueryComparisonExpression withName(String name) {
        this.name = name;
        return this;
    }

    public QueryOperatorType operator() {
        return this.operator;
    }

    public QueryComparisonExpression withOperator(QueryOperatorType operator) {
        this.operator = operator;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public QueryComparisonExpression withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model QueryComparisonExpression"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model QueryComparisonExpression"));
        }
        if (this.values() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property values in model QueryComparisonExpression"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static QueryComparisonExpression fromJson(JsonReader jsonReader) throws IOException {
        return (QueryComparisonExpression)jsonReader.readObject(reader -> {
            QueryComparisonExpression deserializedQueryComparisonExpression = new QueryComparisonExpression();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedQueryComparisonExpression.name = reader.getString();
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedQueryComparisonExpression.operator = QueryOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedQueryComparisonExpression.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryComparisonExpression;
        });
    }
}

