/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.GranularityType;
import com.azure.resourcemanager.costmanagement.models.QueryAggregation;
import com.azure.resourcemanager.costmanagement.models.QueryDatasetConfiguration;
import com.azure.resourcemanager.costmanagement.models.QueryFilter;
import com.azure.resourcemanager.costmanagement.models.QueryGrouping;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class QueryDataset
implements JsonSerializable<QueryDataset> {
    private GranularityType granularity;
    private QueryDatasetConfiguration configuration;
    private Map<String, QueryAggregation> aggregation;
    private List<QueryGrouping> grouping;
    private QueryFilter filter;

    public GranularityType granularity() {
        return this.granularity;
    }

    public QueryDataset withGranularity(GranularityType granularity) {
        this.granularity = granularity;
        return this;
    }

    public QueryDatasetConfiguration configuration() {
        return this.configuration;
    }

    public QueryDataset withConfiguration(QueryDatasetConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Map<String, QueryAggregation> aggregation() {
        return this.aggregation;
    }

    public QueryDataset withAggregation(Map<String, QueryAggregation> aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public List<QueryGrouping> grouping() {
        return this.grouping;
    }

    public QueryDataset withGrouping(List<QueryGrouping> grouping) {
        this.grouping = grouping;
        return this;
    }

    public QueryFilter filter() {
        return this.filter;
    }

    public QueryDataset withFilter(QueryFilter filter) {
        this.filter = filter;
        return this;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.aggregation() != null) {
            this.aggregation().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.grouping() != null) {
            this.grouping().forEach(e -> e.validate());
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeMapField("aggregation", this.aggregation, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("grouping", this.grouping, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("filter", (JsonSerializable)this.filter);
        return jsonWriter.writeEndObject();
    }

    public static QueryDataset fromJson(JsonReader jsonReader) throws IOException {
        return (QueryDataset)jsonReader.readObject(reader -> {
            QueryDataset deserializedQueryDataset = new QueryDataset();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("granularity".equals(fieldName)) {
                    deserializedQueryDataset.granularity = GranularityType.fromString(reader.getString());
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedQueryDataset.configuration = QueryDatasetConfiguration.fromJson(reader);
                    continue;
                }
                if ("aggregation".equals(fieldName)) {
                    Map aggregation;
                    deserializedQueryDataset.aggregation = aggregation = reader.readMap(reader1 -> QueryAggregation.fromJson(reader1));
                    continue;
                }
                if ("grouping".equals(fieldName)) {
                    List grouping;
                    deserializedQueryDataset.grouping = grouping = reader.readArray(reader1 -> QueryGrouping.fromJson(reader1));
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedQueryDataset.filter = QueryFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryDataset;
        });
    }
}

