/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ExportType;
import com.azure.resourcemanager.costmanagement.models.QueryDataset;
import com.azure.resourcemanager.costmanagement.models.QueryTimePeriod;
import com.azure.resourcemanager.costmanagement.models.TimeframeType;
import java.io.IOException;

public final class QueryDefinition
implements JsonSerializable<QueryDefinition> {
    private ExportType type;
    private TimeframeType timeframe;
    private QueryTimePeriod timePeriod;
    private QueryDataset dataset;
    private static final ClientLogger LOGGER = new ClientLogger(QueryDefinition.class);

    public ExportType type() {
        return this.type;
    }

    public QueryDefinition withType(ExportType type) {
        this.type = type;
        return this;
    }

    public TimeframeType timeframe() {
        return this.timeframe;
    }

    public QueryDefinition withTimeframe(TimeframeType timeframe) {
        this.timeframe = timeframe;
        return this;
    }

    public QueryTimePeriod timePeriod() {
        return this.timePeriod;
    }

    public QueryDefinition withTimePeriod(QueryTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        return this;
    }

    public QueryDataset dataset() {
        return this.dataset;
    }

    public QueryDefinition withDataset(QueryDataset dataset) {
        this.dataset = dataset;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model QueryDefinition"));
        }
        if (this.timeframe() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeframe in model QueryDefinition"));
        }
        if (this.timePeriod() != null) {
            this.timePeriod().validate();
        }
        if (this.dataset() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataset in model QueryDefinition"));
        }
        this.dataset().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("timeframe", this.timeframe == null ? null : this.timeframe.toString());
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
        jsonWriter.writeJsonField("timePeriod", (JsonSerializable)this.timePeriod);
        return jsonWriter.writeEndObject();
    }

    public static QueryDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (QueryDefinition)jsonReader.readObject(reader -> {
            QueryDefinition deserializedQueryDefinition = new QueryDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedQueryDefinition.type = ExportType.fromString(reader.getString());
                    continue;
                }
                if ("timeframe".equals(fieldName)) {
                    deserializedQueryDefinition.timeframe = TimeframeType.fromString(reader.getString());
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedQueryDefinition.dataset = QueryDataset.fromJson(reader);
                    continue;
                }
                if ("timePeriod".equals(fieldName)) {
                    deserializedQueryDefinition.timePeriod = QueryTimePeriod.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryDefinition;
        });
    }
}

