/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.QueryComparisonExpression;
import java.io.IOException;
import java.util.List;

public final class QueryFilter
implements JsonSerializable<QueryFilter> {
    private List<QueryFilter> and;
    private List<QueryFilter> or;
    private QueryComparisonExpression dimensions;
    private QueryComparisonExpression tags;

    public List<QueryFilter> and() {
        return this.and;
    }

    public QueryFilter withAnd(List<QueryFilter> and) {
        this.and = and;
        return this;
    }

    public List<QueryFilter> or() {
        return this.or;
    }

    public QueryFilter withOr(List<QueryFilter> or) {
        this.or = or;
        return this;
    }

    public QueryComparisonExpression dimensions() {
        return this.dimensions;
    }

    public QueryFilter withDimensions(QueryComparisonExpression dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public QueryComparisonExpression tags() {
        return this.tags;
    }

    public QueryFilter withTags(QueryComparisonExpression tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.and() != null) {
            this.and().forEach(e -> e.validate());
        }
        if (this.or() != null) {
            this.or().forEach(e -> e.validate());
        }
        if (this.dimensions() != null) {
            this.dimensions().validate();
        }
        if (this.tags() != null) {
            this.tags().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("and", this.and, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("or", this.or, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dimensions", (JsonSerializable)this.dimensions);
        jsonWriter.writeJsonField("tags", (JsonSerializable)this.tags);
        return jsonWriter.writeEndObject();
    }

    public static QueryFilter fromJson(JsonReader jsonReader) throws IOException {
        return (QueryFilter)jsonReader.readObject(reader -> {
            QueryFilter deserializedQueryFilter = new QueryFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("and".equals(fieldName)) {
                    List and;
                    deserializedQueryFilter.and = and = reader.readArray(reader1 -> QueryFilter.fromJson(reader1));
                    continue;
                }
                if ("or".equals(fieldName)) {
                    List or;
                    deserializedQueryFilter.or = or = reader.readArray(reader1 -> QueryFilter.fromJson(reader1));
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    deserializedQueryFilter.dimensions = QueryComparisonExpression.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    deserializedQueryFilter.tags = QueryComparisonExpression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryFilter;
        });
    }
}

