/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.FunctionType;
import java.io.IOException;

public final class ReportConfigAggregation
implements JsonSerializable<ReportConfigAggregation> {
    private String name;
    private FunctionType function;
    private static final ClientLogger LOGGER = new ClientLogger(ReportConfigAggregation.class);

    public String name() {
        return this.name;
    }

    public ReportConfigAggregation withName(String name) {
        this.name = name;
        return this;
    }

    public FunctionType function() {
        return this.function;
    }

    public ReportConfigAggregation withFunction(FunctionType function) {
        this.function = function;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ReportConfigAggregation"));
        }
        if (this.function() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property function in model ReportConfigAggregation"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("function", this.function == null ? null : this.function.toString());
        return jsonWriter.writeEndObject();
    }

    public static ReportConfigAggregation fromJson(JsonReader jsonReader) throws IOException {
        return (ReportConfigAggregation)jsonReader.readObject(reader -> {
            ReportConfigAggregation deserializedReportConfigAggregation = new ReportConfigAggregation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedReportConfigAggregation.name = reader.getString();
                    continue;
                }
                if ("function".equals(fieldName)) {
                    deserializedReportConfigAggregation.function = FunctionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportConfigAggregation;
        });
    }
}

