/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.OperatorType;
import java.io.IOException;
import java.util.List;

public final class ReportConfigComparisonExpression
implements JsonSerializable<ReportConfigComparisonExpression> {
    private String name;
    private OperatorType operator;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(ReportConfigComparisonExpression.class);

    public String name() {
        return this.name;
    }

    public ReportConfigComparisonExpression withName(String name) {
        this.name = name;
        return this;
    }

    public OperatorType operator() {
        return this.operator;
    }

    public ReportConfigComparisonExpression withOperator(OperatorType operator) {
        this.operator = operator;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public ReportConfigComparisonExpression withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ReportConfigComparisonExpression"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model ReportConfigComparisonExpression"));
        }
        if (this.values() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property values in model ReportConfigComparisonExpression"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ReportConfigComparisonExpression fromJson(JsonReader jsonReader) throws IOException {
        return (ReportConfigComparisonExpression)jsonReader.readObject(reader -> {
            ReportConfigComparisonExpression deserializedReportConfigComparisonExpression = new ReportConfigComparisonExpression();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedReportConfigComparisonExpression.name = reader.getString();
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedReportConfigComparisonExpression.operator = OperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedReportConfigComparisonExpression.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportConfigComparisonExpression;
        });
    }
}

